/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.modules.graphql.provider.dxm.osgiconfig;

import graphql.annotations.annotationTypes.GraphQLDescription;
import graphql.annotations.annotationTypes.GraphQLField;
import graphql.annotations.annotationTypes.GraphQLName;
import org.jahia.modules.graphql.provider.dxm.osgiconfig.GqlListMutation;
import org.jahia.services.modulemanager.util.PropertiesValues;

@GraphQLName(value="ConfigurationItemValuesMutation")
@GraphQLDescription(value="Mutation for configuration value object")
public class GqlValueMutation {
    protected PropertiesValues propertiesValues;

    public GqlValueMutation(PropertiesValues values) {
        this.propertiesValues = values;
    }

    protected PropertiesValues getPropertiesValues() {
        return this.propertiesValues;
    }

    @GraphQLField
    @GraphQLDescription(value="Modify a structured object")
    public GqlValueMutation mutateObject(@GraphQLName(value="name") @GraphQLDescription(value="property name part") String name) {
        return new GqlValueMutation(this.getPropertiesValues().getValues(name));
    }

    @GraphQLField
    @GraphQLDescription(value="Modify a list of items")
    public GqlListMutation mutateList(@GraphQLName(value="name") @GraphQLDescription(value="property name part") String name) {
        return new GqlListMutation(this.getPropertiesValues().getList(name));
    }

    @GraphQLField
    @GraphQLDescription(value="Set a property value")
    public String setValue(@GraphQLName(value="name") @GraphQLDescription(value="property name part") String name, @GraphQLName(value="value") String value) {
        this.getPropertiesValues().setProperty(name, value);
        return value;
    }

    @GraphQLField
    @GraphQLDescription(value="Remove the specified property and all sub/list properties")
    public boolean remove(@GraphQLName(value="name") @GraphQLDescription(value="property name part") String name) {
        this.getPropertiesValues().remove(name);
        return true;
    }
}

