/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.modules.graphql.provider.dxm.osgiconfig;

import graphql.annotations.annotationTypes.GraphQLDescription;
import graphql.annotations.annotationTypes.GraphQLField;
import graphql.annotations.annotationTypes.GraphQLName;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jahia.modules.graphql.provider.dxm.osgiconfig.GqlConfigurationProperty;
import org.jahia.modules.graphql.provider.dxm.osgiconfig.GqlListQuery;
import org.jahia.services.modulemanager.util.PropertiesList;
import org.jahia.services.modulemanager.util.PropertiesValues;

@GraphQLName(value="ConfigurationItemValuesQuery")
@GraphQLDescription(value="Query for configuration value object")
public class GqlValueQuery {
    protected PropertiesValues propertiesValues;

    public GqlValueQuery(PropertiesValues v) {
        this.propertiesValues = v;
    }

    protected PropertiesValues getPropertiesValues() {
        return this.propertiesValues;
    }

    @GraphQLField
    @GraphQLDescription(value="Get keys")
    public Set<String> getKeys() {
        return this.getPropertiesValues().getKeys();
    }

    @GraphQLField
    @GraphQLDescription(value="Get a sub structured object value")
    public GqlValueQuery getObject(@GraphQLName(value="name") @GraphQLDescription(value="property name part") String name) {
        PropertiesValues values = this.getPropertiesValues().getValues(name);
        if (!values.getKeys().isEmpty()) {
            return new GqlValueQuery(values);
        }
        return null;
    }

    @GraphQLField
    @GraphQLDescription(value="Get a list of items")
    public GqlListQuery getList(@GraphQLName(value="name") @GraphQLDescription(value="property name part") String name) {
        PropertiesList list = this.getPropertiesValues().getList(name);
        if (list.getSize() > 0) {
            return new GqlListQuery(list);
        }
        return null;
    }

    @GraphQLField
    @GraphQLDescription(value="Get a property value")
    public String getValue(@GraphQLName(value="name") @GraphQLDescription(value="property name part") String name) {
        return this.getPropertiesValues().getProperty(name);
    }

    @GraphQLField
    @GraphQLDescription(value="Get property values")
    public List<GqlConfigurationProperty> getValues() {
        return this.getKeys().stream().map(k -> new GqlConfigurationProperty((String)k, this.getValue((String)k))).collect(Collectors.toList());
    }
}

