/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.modules.graphql.provider.dxm.publication;

import graphql.annotations.annotationTypes.GraphQLDescription;
import graphql.annotations.annotationTypes.GraphQLField;
import graphql.annotations.annotationTypes.GraphQLName;
import graphql.annotations.annotationTypes.GraphQLNonNull;
import javax.jcr.ItemNotFoundException;
import javax.jcr.RepositoryException;
import org.jahia.modules.graphql.provider.dxm.DataFetchingException;
import org.jahia.modules.graphql.provider.dxm.node.GqlJcrNode;
import org.jahia.modules.graphql.provider.dxm.publication.GqlPublicationStatus;
import org.jahia.services.content.ComplexPublicationService;
import org.jahia.services.content.JCRTemplate;

@GraphQLDescription(value="Publication status information for a JCR node")
public class GqlPublicationInfo {
    private ComplexPublicationService.AggregatedPublicationInfo aggregatedInfo;
    private GqlJcrNode node;

    public GqlPublicationInfo(ComplexPublicationService.AggregatedPublicationInfo aggregatedInfo, GqlJcrNode node) {
        this.aggregatedInfo = aggregatedInfo;
        this.node = node;
    }

    @GraphQLField
    @GraphQLName(value="publicationStatus")
    @GraphQLNonNull
    @GraphQLDescription(value="Aggregated publication status of the node")
    public GqlPublicationStatus getPublicationStatus() {
        return GqlPublicationStatus.fromStatusValue(this.aggregatedInfo.getPublicationStatus());
    }

    @GraphQLField
    @GraphQLName(value="locked")
    @GraphQLDescription(value="Aggregated locked status of the node")
    public boolean isLocked() {
        return this.aggregatedInfo.isLocked();
    }

    @GraphQLField
    @GraphQLName(value="workInProgress")
    @GraphQLDescription(value="Aggregated work-in-progress status of the node")
    public boolean isWorkInProgress() {
        return this.aggregatedInfo.isWorkInProgress();
    }

    @GraphQLField
    @GraphQLName(value="allowedToPublishWithoutWorkflow")
    @GraphQLDescription(value="Whether current user is allowed to publish the node omitting any workflows")
    public boolean isAllowedToPublishWithoutWorkflow() {
        return this.aggregatedInfo.isAllowedToPublishWithoutWorkflow();
    }

    @GraphQLField
    @GraphQLName(value="existsInLive")
    @GraphQLDescription(value="Whether node exists in live workspace")
    public boolean existsInLive() {
        try {
            JCRTemplate.getInstance().getSessionFactory().getCurrentUserSession("live").getNodeByIdentifier(this.node.getUuid());
            return true;
        }
        catch (ItemNotFoundException e) {
            return false;
        }
        catch (RepositoryException e) {
            throw new DataFetchingException(e);
        }
    }
}

