/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.modules.graphql.provider.dxm.publication;

import graphql.annotations.annotationTypes.GraphQLDefaultValue;
import graphql.annotations.annotationTypes.GraphQLDescription;
import graphql.annotations.annotationTypes.GraphQLField;
import graphql.annotations.annotationTypes.GraphQLName;
import graphql.annotations.annotationTypes.GraphQLNonNull;
import graphql.annotations.annotationTypes.GraphQLTypeExtension;
import javax.jcr.RepositoryException;
import org.jahia.exceptions.JahiaRuntimeException;
import org.jahia.modules.graphql.provider.dxm.node.GqlJcrNode;
import org.jahia.modules.graphql.provider.dxm.node.GqlJcrWrongInputException;
import org.jahia.modules.graphql.provider.dxm.publication.GqlPublicationInfo;
import org.jahia.modules.graphql.provider.dxm.publication.PublicationJCRExtensionSupport;
import org.jahia.modules.graphql.provider.dxm.util.GqlUtils;
import org.jahia.osgi.BundleUtils;
import org.jahia.services.content.ComplexPublicationService;
import org.jahia.services.content.JCRSessionFactory;
import org.jahia.services.content.JCRSessionWrapper;

@GraphQLTypeExtension(value=GqlJcrNode.class)
public class PublicationJCRNodeExtension
extends PublicationJCRExtensionSupport {
    private GqlJcrNode gqlJcrNode;

    public PublicationJCRNodeExtension(GqlJcrNode node) throws GqlJcrWrongInputException {
        this.validateNodeWorkspace(node);
        this.gqlJcrNode = node;
    }

    @GraphQLField
    @GraphQLNonNull
    @GraphQLDescription(value="Aggregated publication info about the JCR node")
    public GqlPublicationInfo getAggregatedPublicationInfo(@GraphQLName(value="language") @GraphQLNonNull @GraphQLDescription(value="Publication language") String language, @GraphQLName(value="subNodes") @GraphQLDefaultValue(value=GqlUtils.SupplierFalse.class) @GraphQLDescription(value="Whether to take sub-nodes into account when calculating the aggregated publication status") boolean subNodes, @GraphQLName(value="references") @GraphQLDefaultValue(value=GqlUtils.SupplierFalse.class) @GraphQLDescription(value="Whether to take references into account when calculating the aggregated publication status") boolean references) {
        ComplexPublicationService publicationService = (ComplexPublicationService)BundleUtils.getOsgiService(ComplexPublicationService.class, null);
        ComplexPublicationService.AggregatedPublicationInfo aggregatedInfo = null;
        try {
            JCRSessionWrapper session = JCRSessionFactory.getInstance().getCurrentUserSession();
            aggregatedInfo = publicationService.getAggregatedPublicationInfo(this.gqlJcrNode.getUuid(), language, subNodes, references, session);
        }
        catch (RuntimeException e) {
            return new GqlPublicationInfo(new EmptyAggregateInfo(), this.gqlJcrNode);
        }
        catch (RepositoryException e) {
            throw new JahiaRuntimeException((Throwable)e);
        }
        return new GqlPublicationInfo(aggregatedInfo, this.gqlJcrNode);
    }

    private static class EmptyAggregateInfo
    implements ComplexPublicationService.AggregatedPublicationInfo {
        private EmptyAggregateInfo() {
        }

        public int getPublicationStatus() {
            return 4;
        }

        public boolean isLocked() {
            return false;
        }

        public boolean isWorkInProgress() {
            return false;
        }

        public boolean isAllowedToPublishWithoutWorkflow() {
            return false;
        }

        public boolean isNonRootMarkedForDeletion() {
            return false;
        }
    }
}

