/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.modules.graphql.provider.dxm.publication;

import graphql.annotations.annotationTypes.GraphQLDefaultValue;
import graphql.annotations.annotationTypes.GraphQLDescription;
import graphql.annotations.annotationTypes.GraphQLField;
import graphql.annotations.annotationTypes.GraphQLName;
import graphql.annotations.annotationTypes.GraphQLTypeExtension;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.jcr.RepositoryException;
import org.apache.commons.lang.BooleanUtils;
import org.jahia.exceptions.JahiaRuntimeException;
import org.jahia.modules.graphql.provider.dxm.node.GqlJcrNodeMutation;
import org.jahia.modules.graphql.provider.dxm.node.GqlJcrWrongInputException;
import org.jahia.modules.graphql.provider.dxm.publication.PublicationJCRExtensionSupport;
import org.jahia.modules.graphql.provider.dxm.util.GqlUtils;
import org.jahia.osgi.BundleUtils;
import org.jahia.services.content.ComplexPublicationService;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRPublicationService;
import org.jahia.services.content.JCRSessionFactory;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.PublicationJob;
import org.jahia.services.scheduler.BackgroundJob;
import org.jahia.services.scheduler.SchedulerService;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.SchedulerException;

@GraphQLTypeExtension(value=GqlJcrNodeMutation.class)
public class PublicationJCRNodeMutationExtension
extends PublicationJCRExtensionSupport {
    private GqlJcrNodeMutation nodeMutation;

    public PublicationJCRNodeMutationExtension(GqlJcrNodeMutation nodeMutation) throws GqlJcrWrongInputException {
        this.validateNodeWorkspace(nodeMutation.getNode());
        this.nodeMutation = nodeMutation;
    }

    @GraphQLField
    @GraphQLDescription(value="Publish the node in certain languages")
    public boolean publish(@GraphQLName(value="languages") @GraphQLDescription(value="Languages to publish the node in") Collection<String> languages, @GraphQLName(value="publishSubNodes") @GraphQLDefaultValue(value=GqlUtils.SupplierTrue.class) @GraphQLDescription(value="Publish all sub and related nodes. Default is true.") Boolean publishSubNodes, @GraphQLName(value="includeSubTree") @GraphQLDefaultValue(value=GqlUtils.SupplierFalse.class) @GraphQLDescription(value="Publish all sub tree including sub pages. Default is false.") Boolean publishAllSubTree) {
        JCRSessionWrapper session;
        String path;
        String uuid;
        ComplexPublicationService publicationService = (ComplexPublicationService)BundleUtils.getOsgiService(ComplexPublicationService.class, null);
        SchedulerService schedulerService = (SchedulerService)BundleUtils.getOsgiService(SchedulerService.class, null);
        try {
            JCRNodeWrapper nodeToPublish = this.nodeMutation.getNode().getNode();
            uuid = nodeToPublish.getIdentifier();
            path = nodeToPublish.getPath();
            session = JCRSessionFactory.getInstance().getCurrentUserSession();
        }
        catch (RepositoryException e) {
            throw new JahiaRuntimeException((Throwable)e);
        }
        if (BooleanUtils.isFalse((Boolean)publishSubNodes)) {
            JobDetail jobDetail = BackgroundJob.createJahiaJob((String)"Publication", PublicationJob.class);
            JobDataMap jobDataMap = jobDetail.getJobDataMap();
            jobDataMap.put((Object)"publicationInfos", Collections.singletonList(uuid));
            jobDataMap.put((Object)"publicationPaths", Collections.singletonList(path));
            jobDataMap.put("source", "default");
            jobDataMap.put("destination", "live");
            jobDataMap.put("checkPermissions", true);
            try {
                schedulerService.scheduleJobNow(jobDetail);
            }
            catch (SchedulerException e) {
                throw new JahiaRuntimeException((Throwable)e);
            }
        } else {
            publicationService.publish(Collections.singleton(uuid), languages, session, publishAllSubTree);
        }
        return true;
    }

    @GraphQLField
    @GraphQLDescription(value="Unpublish the node in certain languages")
    public boolean unpublish(@GraphQLName(value="languages") @GraphQLDescription(value="Languages to publish the node in") Collection<String> languages) {
        ComplexPublicationService publicationService = (ComplexPublicationService)BundleUtils.getOsgiService(ComplexPublicationService.class, null);
        JCRPublicationService jcrPublicationService = (JCRPublicationService)BundleUtils.getOsgiService(JCRPublicationService.class, null);
        try {
            JCRSessionWrapper session = JCRSessionFactory.getInstance().getCurrentUserSession();
            Collection fullPublicationInfo = publicationService.getFullUnpublicationInfos(Collections.singletonList(this.nodeMutation.getNode().getNode().getIdentifier()), languages, false, session);
            List<String> uuidsToUnpublish = PublicationJCRNodeMutationExtension.getAllUuids(fullPublicationInfo, true);
            jcrPublicationService.unpublish(uuidsToUnpublish, true);
        }
        catch (RepositoryException e) {
            throw new JahiaRuntimeException((Throwable)e);
        }
        return true;
    }

    private static List<String> getAllUuids(Collection<ComplexPublicationService.FullPublicationInfo> fullPublicationInfo, boolean onlyAllowedToPublishWithoutWorkflow) {
        ArrayList<String> l = new ArrayList<String>();
        for (ComplexPublicationService.FullPublicationInfo info : fullPublicationInfo) {
            if (info.getPublicationStatus() == 11 || onlyAllowedToPublishWithoutWorkflow && !info.isAllowedToPublishWithoutWorkflow()) continue;
            if (info.getNodeIdentifier() != null) {
                l.add(info.getNodeIdentifier());
            }
            if (info.getTranslationNodeIdentifier() != null) {
                l.add(info.getTranslationNodeIdentifier());
            }
            if (info.getDeletedTranslationNodeIdentifiers() == null) continue;
            l.addAll(info.getDeletedTranslationNodeIdentifiers());
        }
        return l;
    }
}

