/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.modules.graphql.provider.dxm.relay;

import graphql.Scalars;
import graphql.relay.Relay;
import graphql.schema.GraphQLArgument;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLInputType;
import graphql.schema.GraphQLInterfaceType;
import graphql.schema.GraphQLList;
import graphql.schema.GraphQLNonNull;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLType;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DXRelay
extends Relay {
    private Map<String, GraphQLObjectType> connectionTypes = new HashMap<String, GraphQLObjectType>();
    public final GraphQLObjectType pageInfoType = GraphQLObjectType.newObject().name("PageInfo").description("Information about pagination in a connection.").field(GraphQLFieldDefinition.newFieldDefinition().name("hasNextPage").type((GraphQLOutputType)new GraphQLNonNull((GraphQLType)Scalars.GraphQLBoolean)).description("When paginating forwards, are there more items?")).field(GraphQLFieldDefinition.newFieldDefinition().name("hasPreviousPage").type((GraphQLOutputType)new GraphQLNonNull((GraphQLType)Scalars.GraphQLBoolean)).description("When paginating backwards, are there more items?")).field(GraphQLFieldDefinition.newFieldDefinition().name("startCursor").type((GraphQLOutputType)Scalars.GraphQLString).description("When paginating backwards, the cursor to continue.")).field(GraphQLFieldDefinition.newFieldDefinition().name("endCursor").type((GraphQLOutputType)Scalars.GraphQLString).description("When paginating forwards, the cursor to continue.")).field(GraphQLFieldDefinition.newFieldDefinition().name("nodesCount").type((GraphQLOutputType)Scalars.GraphQLInt).description("When paginating forwards, the cursor to continue.")).field(GraphQLFieldDefinition.newFieldDefinition().name("totalCount").type((GraphQLOutputType)Scalars.GraphQLInt).description("When paginating forwards, the cursor to continue.")).build();

    public void addConnectionType(String connectionType, GraphQLObjectType connectionOutputType) {
        this.connectionTypes.put(connectionType, connectionOutputType);
    }

    public Map<String, GraphQLObjectType> getConnectionTypes() {
        return this.connectionTypes;
    }

    public GraphQLObjectType connectionType(String name, GraphQLObjectType edgeType, List<GraphQLFieldDefinition> connectionFields) {
        GraphQLObjectType.Builder builder = GraphQLObjectType.newObject().name(name + "Connection").description("A connection to a list of items.").field(GraphQLFieldDefinition.newFieldDefinition().name("nodes").description("a list of nodes").type((GraphQLOutputType)new GraphQLList((GraphQLType)edgeType.getFieldDefinition("node").getType()))).field(GraphQLFieldDefinition.newFieldDefinition().name("edges").description("a list of edges").type((GraphQLOutputType)new GraphQLList((GraphQLType)edgeType))).field(GraphQLFieldDefinition.newFieldDefinition().name("pageInfo").description("details about this specific page").type((GraphQLOutputType)new GraphQLNonNull((GraphQLType)this.pageInfoType))).fields(connectionFields);
        if (this.connectionTypes.containsKey(name + "Connection")) {
            GraphQLObjectType graphQLOutputType = this.connectionTypes.get(name + "Connection");
            builder.fields(graphQLOutputType.getFieldDefinitions());
        }
        return builder.build();
    }

    public List<GraphQLArgument> getConnectionFieldArguments() {
        List args = super.getConnectionFieldArguments();
        args.add(GraphQLArgument.newArgument().name("offset").description("fetching only nodes after this node (inclusive)").type((GraphQLInputType)Scalars.GraphQLInt).build());
        args.add(GraphQLArgument.newArgument().name("limit").description("fetching only the first certain number of nodes").type((GraphQLInputType)Scalars.GraphQLInt).build());
        return args;
    }

    public GraphQLObjectType edgeType(String name, GraphQLOutputType nodeType, GraphQLInterfaceType nodeInterface, List<GraphQLFieldDefinition> edgeFields) {
        return GraphQLObjectType.newObject().name(name + "Edge").description("An edge in a connection").field(GraphQLFieldDefinition.newFieldDefinition().name("node").type(nodeType).description("The item at the end of the edge")).field(GraphQLFieldDefinition.newFieldDefinition().name("cursor").type((GraphQLOutputType)new GraphQLNonNull((GraphQLType)Scalars.GraphQLString)).description("cursor marks a unique position or index into the connection")).field(GraphQLFieldDefinition.newFieldDefinition().name("index").type((GraphQLOutputType)Scalars.GraphQLInt).description("index in the connection")).fields(edgeFields).build();
    }
}

