/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.modules.graphql.provider.dxm.relay;

import graphql.schema.DataFetchingEnvironment;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;
import org.apache.commons.collections.iterators.IteratorChain;
import org.apache.commons.collections4.queue.CircularFifoQueue;
import org.apache.commons.lang.mutable.MutableInt;
import org.apache.commons.lang.mutable.MutableObject;
import org.jahia.modules.graphql.provider.dxm.DataFetchingException;
import org.jahia.modules.graphql.provider.dxm.node.GqlJcrWrongInputException;
import org.jahia.modules.graphql.provider.dxm.relay.AbstractDXPaginatedData;
import org.jahia.modules.graphql.provider.dxm.relay.CursorSupport;
import org.jahia.modules.graphql.provider.dxm.relay.DXPaginatedData;
import org.jahia.modules.graphql.provider.dxm.util.StreamUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PaginationHelper {
    private static Logger logger = LoggerFactory.getLogger(PaginationHelper.class);
    private static AtomicInteger nodeLimit = new AtomicInteger(5000);

    private PaginationHelper() {
    }

    public static <T> DXPaginatedData<T> paginate(List<T> source, DataFetchingEnvironment environment) {
        Arguments arguments = PaginationHelper.parseArguments(environment);
        return PaginationHelper.paginate(source, (T obj) -> PaginationHelper.encodeCursor("index:" + source.indexOf(obj)), arguments);
    }

    public static <T> DXPaginatedData<T> paginate(List<T> source, CursorSupport<T> cursorSupport, Arguments arguments) {
        List<T> filtered = PaginationHelper.applyCursorsToEdge(arguments, source, cursorSupport);
        filtered = PaginationHelper.applyFirstLast(filtered, arguments);
        boolean hasPrevious = !(filtered = PaginationHelper.applyLimitOffset(filtered, arguments)).isEmpty() && filtered.get(0) != source.get(0);
        boolean hasNext = !filtered.isEmpty() && filtered.get(filtered.size() - 1) != source.get(source.size() - 1);
        return new SimpleDXPaginatedData<T>(source, filtered, cursorSupport, hasPrevious, hasNext);
    }

    public static <T> List<T> applyLimitOffset(List<T> filtered, Arguments args) {
        if (args.offset != null) {
            filtered = filtered.subList(Math.min(args.offset, filtered.size()), filtered.size());
        }
        if (args.limit != null) {
            filtered = filtered.subList(0, filtered.size() > args.limit ? args.limit.intValue() : filtered.size());
        }
        return filtered;
    }

    public static <T> List<T> applyFirstLast(List<T> filtered, Arguments args) {
        if (args.first != null) {
            filtered = filtered.subList(0, filtered.size() > args.first ? args.first.intValue() : filtered.size());
        }
        if (args.last != null) {
            filtered = filtered.subList(filtered.size() > args.last ? filtered.size() - args.last : 0, filtered.size());
        }
        return filtered;
    }

    public static <T> List<T> applyCursorsToEdge(Arguments args, List<T> filtered, CursorSupport<T> cursorSupport) {
        Optional<Object> before;
        Optional<Object> after;
        if (args.after != null && (after = filtered.stream().filter(s -> args.after.equals(cursorSupport.getCursor(s))).findFirst()).isPresent()) {
            filtered = filtered.subList(filtered.indexOf(after.get()) + 1, filtered.size());
        }
        if (args.before != null && (before = filtered.stream().filter(s -> args.before.equals(cursorSupport.getCursor(s))).findFirst()).isPresent()) {
            filtered = filtered.subList(0, filtered.indexOf(before.get()));
        }
        return filtered;
    }

    public static <T> DXPaginatedData<T> paginate(Stream<T> source, CursorSupport<T> cursorSupport, Arguments arguments) {
        MutableInt count = new MutableInt(0);
        MutableObject last = new MutableObject();
        if (arguments.isCursor() && arguments.after != null) {
            source = StreamUtils.dropUntil(source, t -> cursorSupport.getCursor(t).equals(arguments.after), count).skip(1L);
        } else if (arguments.isOffsetLimit() && arguments.offset != null && arguments.offset > 0) {
            source = StreamUtils.dropUntil(source, t -> count.intValue() == arguments.offset.intValue(), count).skip(1L);
        }
        IteratorChain it = source.iterator();
        List filtered = PaginationHelper.collectItems(it, arguments, cursorSupport, count, last);
        count.subtract(filtered.size());
        boolean hasPrevious = count.intValue() > 0;
        boolean hasNext = false;
        if (arguments.limit != null) {
            hasNext = filtered.size() > arguments.limit;
        } else if (arguments.first != null) {
            boolean bl = hasNext = filtered.size() > arguments.first;
        }
        if (!hasNext && arguments.before != null) {
            boolean bl = hasNext = !filtered.isEmpty() && arguments.before.equals(cursorSupport.getCursor(filtered.get(filtered.size() - 1)));
            if (!hasNext && hasPrevious && arguments.last != null) {
                filtered = filtered.subList(1, filtered.size());
                count.increment();
            }
        }
        if (hasNext) {
            it = new IteratorChain(Collections.singleton(filtered.get(filtered.size() - 1)).iterator(), it);
            filtered = filtered.subList(0, filtered.size() - 1);
        }
        return new StreamBasedDXPaginatedData(filtered, cursorSupport, hasPrevious, hasNext, count.intValue(), it);
    }

    @NotNull
    private static <T> List<T> collectItems(Iterator<T> it, Arguments arguments, CursorSupport<T> cursorSupport, MutableInt count, MutableObject last) {
        int nodeLimit = PaginationHelper.getNodeLimit();
        CircularFifoQueue items = arguments.last == null ? new ArrayList() : (arguments.before == null ? new CircularFifoQueue(arguments.last.intValue()) : new CircularFifoQueue(arguments.last + 1));
        while (!(!it.hasNext() || arguments.limit != null && items.size() > arguments.limit || arguments.first != null && items.size() > arguments.first)) {
            T value = it.next();
            last.setValue(value);
            items.add(value);
            count.increment();
            if (arguments.before != null && cursorSupport.getCursor(value).equals(arguments.before)) break;
            if (count.intValue() == 500) {
                logger.warn("The current paginated query is returning more than 500 items. This may cause a memory leak.");
                continue;
            }
            if (count.intValue() != nodeLimit || !logger.isWarnEnabled()) continue;
            logger.warn("The current paginated query is returning more than {} items. Stopping the query.", (Object)nodeLimit, (Object)new DataFetchingException("The current paginated query is returning more than " + nodeLimit + " items. Stopping the query here."));
            break;
        }
        return new ArrayList(items);
    }

    public static void updateLimit(int limit) {
        logger.info("Node limit has been updated to {}", (Object)limit);
        nodeLimit.set(limit);
    }

    public static int getNodeLimit() {
        return nodeLimit.get();
    }

    public static Arguments parseArguments(DataFetchingEnvironment environment) {
        return new Arguments((String)environment.getArgument("before"), (String)environment.getArgument("after"), (Integer)environment.getArgument("first"), (Integer)environment.getArgument("last"), (Integer)environment.getArgument("offset"), (Integer)environment.getArgument("limit"));
    }

    public static String encodeCursor(String s) {
        return Base64.getEncoder().encodeToString(s.getBytes(StandardCharsets.UTF_8));
    }

    public static class StreamBasedDXPaginatedData<T>
    extends AbstractDXPaginatedData<T> {
        private final List<T> filtered;
        private final Iterator<T> remaining;
        private final CursorSupport<T> cursorSupport;
        private int startOffset = 0;

        public StreamBasedDXPaginatedData(List<T> filtered, CursorSupport<T> cursorSupport, boolean hasPrevious, boolean hasNext, int startOffset, Iterator<T> remaining) {
            super(filtered, hasPrevious, hasNext, filtered.size(), -1);
            this.filtered = filtered;
            this.remaining = remaining;
            this.cursorSupport = cursorSupport;
            this.startOffset = startOffset;
        }

        public String getCursor(T entity) {
            return this.cursorSupport.getCursor(entity);
        }

        @Override
        public int getIndex(T entity) {
            return this.startOffset + this.filtered.indexOf(entity);
        }

        @Override
        public int getTotalCount() {
            if (this.totalCount == -1) {
                this.totalCount = this.startOffset + this.filtered.size();
                while (this.remaining.hasNext()) {
                    this.remaining.next();
                    ++this.totalCount;
                }
            }
            return this.totalCount;
        }
    }

    public static class SimpleDXPaginatedData<T>
    extends AbstractDXPaginatedData<T> {
        private final List<T> source;
        private final CursorSupport<T> cursorSupport;

        public SimpleDXPaginatedData(List<T> source, List<T> filtered, CursorSupport<T> cursorSupport, boolean hasPrevious, boolean hasNext) {
            super(filtered, hasPrevious, hasNext, filtered.size(), source.size());
            this.source = source;
            this.cursorSupport = cursorSupport;
        }

        public String getCursor(T entity) {
            return this.cursorSupport.getCursor(entity);
        }

        @Override
        public int getIndex(T entity) {
            return this.source.indexOf(entity);
        }
    }

    public static class Arguments {
        String before;
        String after;
        Integer first;
        Integer last;
        Integer offset;
        Integer limit;

        public boolean isOffsetLimit() {
            return this.offset != null || this.limit != null;
        }

        public boolean isCursor() {
            return this.before != null || this.after != null || this.first != null || this.last != null;
        }

        private Integer validateNotNegativeValue(Integer value, String argument) {
            if (value != null && value < 0) {
                throw new GqlJcrWrongInputException("Argument '" + argument + "' can't be negative");
            }
            return value;
        }

        public Arguments(String before, String after, Integer first, Integer last, Integer offset, Integer limit) {
            this.before = before;
            this.after = after;
            this.first = this.validateNotNegativeValue(first, "first");
            this.last = this.validateNotNegativeValue(last, "last");
            this.offset = this.validateNotNegativeValue(offset, "offset");
            this.limit = this.validateNotNegativeValue(limit, "limit");
            if (this.isCursor() && this.isOffsetLimit()) {
                throw new GqlJcrWrongInputException("Offset and/or Limit argument(s) can't be used with other pagination arguments");
            }
        }
    }
}

