/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.modules.graphql.provider.dxm.scheduler;

import io.reactivex.FlowableEmitter;
import java.util.function.Predicate;
import org.jahia.modules.graphql.provider.dxm.scheduler.jobs.GqlBackgroundJob;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.listeners.JobListenerSupport;

public class GqlJobListener
extends JobListenerSupport {
    private String name;
    private FlowableEmitter<GqlBackgroundJob> obs;
    private Predicate<GqlBackgroundJob> jobFilter;

    public GqlJobListener(String name, FlowableEmitter<GqlBackgroundJob> obs, Predicate<GqlBackgroundJob> jobFilter) {
        this.name = name;
        this.obs = obs;
        this.jobFilter = jobFilter;
    }

    public String getName() {
        return this.name;
    }

    public void jobToBeExecuted(JobExecutionContext context) {
        this.submitJobEvent(context, GqlBackgroundJob.GqlBackgroundJobState.STARTED);
    }

    public void jobExecutionVetoed(JobExecutionContext context) {
        this.submitJobEvent(context, GqlBackgroundJob.GqlBackgroundJobState.VETOED);
    }

    public void jobWasExecuted(JobExecutionContext context, JobExecutionException jobException) {
        this.submitJobEvent(context, GqlBackgroundJob.GqlBackgroundJobState.FINISHED);
    }

    private void submitJobEvent(JobExecutionContext context, GqlBackgroundJob.GqlBackgroundJobState state) {
        GqlBackgroundJob gqlBackgroundJob = new GqlBackgroundJob(context.getJobDetail(), state);
        if (this.jobFilter.test(gqlBackgroundJob)) {
            this.obs.onNext((Object)gqlBackgroundJob);
        }
    }
}

