/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.modules.graphql.provider.dxm.sdl.fetchers;

import graphql.schema.DataFetchingEnvironment;
import java.util.List;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.jcr.RepositoryException;
import org.jahia.modules.graphql.provider.dxm.DataFetchingException;
import org.jahia.modules.graphql.provider.dxm.node.GqlJcrNode;
import org.jahia.modules.graphql.provider.dxm.node.SpecializedTypesHandler;
import org.jahia.modules.graphql.provider.dxm.sdl.fetchers.Finder;
import org.jahia.modules.graphql.provider.dxm.sdl.fetchers.FinderListDataFetcher;
import org.jahia.modules.graphql.provider.dxm.sdl.validation.ArgumentValidator;
import org.jahia.modules.graphql.provider.dxm.security.PermissionHelper;
import org.jahia.services.content.JCRNodeIteratorWrapper;
import pl.touk.throwing.ThrowingFunction;

public class AllFinderDataFetcher
extends FinderListDataFetcher {
    public AllFinderDataFetcher(Finder finder) {
        super(finder.getType(), finder);
    }

    @Override
    public List<GqlJcrNode> get(DataFetchingEnvironment environment) {
        if (!ArgumentValidator.validate(ArgumentValidator.ArgumentNames.SORT_BY, environment)) {
            return null;
        }
        return this.getStream(environment).collect(Collectors.toList());
    }

    @Override
    public Stream<GqlJcrNode> getStream(DataFetchingEnvironment environment) {
        if (!ArgumentValidator.validate(ArgumentValidator.ArgumentNames.SORT_BY, environment)) {
            return Stream.empty();
        }
        try {
            String statement = "select * from [\"" + this.type + "\"]";
            JCRNodeIteratorWrapper it = AllFinderDataFetcher.getCurrentUserSession(environment).getWorkspace().getQueryManager().createQuery(statement, "JCR-SQL2").execute().getNodes();
            Stream<GqlJcrNode> stream = StreamSupport.stream(Spliterators.spliteratorUnknownSize(it, 16), false).filter(node -> PermissionHelper.hasPermission(node, environment)).map(ThrowingFunction.unchecked(SpecializedTypesHandler::getNode));
            return this.resolveCollection(stream, environment);
        }
        catch (RepositoryException e) {
            throw new DataFetchingException(e);
        }
    }
}

