/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.modules.graphql.provider.dxm.sdl.fetchers;

import graphql.schema.DataFetchingEnvironment;
import graphql.schema.GraphQLArgument;
import graphql.schema.GraphQLDirective;
import graphql.schema.GraphQLList;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLType;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.jcr.RepositoryException;
import org.jahia.modules.graphql.provider.dxm.node.GqlJcrNode;
import org.jahia.modules.graphql.provider.dxm.node.GqlJcrNodeImpl;
import org.jahia.modules.graphql.provider.dxm.sdl.fetchers.Field;
import org.jahia.modules.graphql.provider.dxm.sdl.fetchers.FinderListDataFetcher;
import org.jahia.services.content.JCRContentUtils;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRValueWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListDataFetcher
extends FinderListDataFetcher {
    private static Logger logger = LoggerFactory.getLogger(ListDataFetcher.class);
    private Field field;

    public ListDataFetcher(Field field) {
        super("", null);
        this.field = field;
    }

    @Override
    public List get(DataFetchingEnvironment environment) {
        return this.getStream(environment).collect(Collectors.toList());
    }

    @Override
    public Stream<GqlJcrNode> getStream(DataFetchingEnvironment environment) {
        GraphQLObjectType obj;
        GraphQLDirective mappingDirective;
        GqlJcrNode node = (GqlJcrNode)environment.getSource();
        JCRNodeWrapper jcrNode = node.getNode();
        if (environment.getFieldDefinition().getType() instanceof GraphQLObjectType && (mappingDirective = (obj = (GraphQLObjectType)((GraphQLList)((GraphQLObjectType)environment.getFieldDefinition().getType()).getFieldDefinition("nodes").getType()).getWrappedType()).getDirective("mapping")) != null) {
            String nodeType = mappingDirective.getArgument("node").getValue().toString();
            return this.resolveChildren(jcrNode, nodeType);
        }
        GraphQLType type = this.resolveWrappedObject((GraphQLType)environment.getFieldDefinition().getType());
        if (type instanceof GraphQLObjectType) {
            mappingDirective = ((GraphQLObjectType)type).getDirective("mapping");
            GraphQLArgument arg = mappingDirective != null ? mappingDirective.getArgument("node") : null;
            return this.resolveFromArgument(jcrNode, arg);
        }
        try {
            return this.resolveProperty(jcrNode);
        }
        catch (RepositoryException e) {
            throw new RuntimeException(e);
        }
    }

    private GraphQLType resolveWrappedObject(GraphQLType type) {
        return type instanceof GraphQLList ? ((GraphQLList)type).getWrappedType() : type;
    }

    private Object getProperty(int propertyType, JCRValueWrapper value) {
        try {
            switch (propertyType) {
                case 1: {
                    return value.getString();
                }
                case 6: {
                    return value.getBoolean();
                }
                case 4: {
                    return value.getDouble();
                }
                case 3: {
                    return value.getLong();
                }
                case 10: {
                    logger.debug("Fetch weak reference {}", (Object)this.field.getProperty());
                    return new GqlJcrNodeImpl(value.getNode());
                }
            }
            return null;
        }
        catch (RepositoryException ex) {
            logger.error("Failed to retrieve node property {}", (Throwable)ex);
            return null;
        }
    }

    private Stream resolveProperty(JCRNodeWrapper jcrNode) throws RepositoryException {
        if (!jcrNode.hasProperty(this.field.getProperty())) {
            return Stream.empty();
        }
        int propertyType = jcrNode.getProperty(this.field.getProperty()).getType();
        return Arrays.stream(jcrNode.getProperty(this.field.getProperty()).getRealValues()).map(value -> this.getProperty(propertyType, (JCRValueWrapper)value)).filter(Objects::nonNull);
    }

    private Stream<GqlJcrNode> resolveChildren(JCRNodeWrapper node, String nodeType) {
        return JCRContentUtils.getChildrenOfType((JCRNodeWrapper)node, (String)nodeType).stream().map(GqlJcrNodeImpl::new);
    }

    private Stream resolveFromArgument(JCRNodeWrapper node, GraphQLArgument arg) {
        if (arg != null) {
            try {
                String nodeType = arg.getValue().toString();
                if (this.field == null) {
                    logger.debug("Fetch children of type {}", (Object)nodeType);
                    return this.resolveChildren(node, nodeType);
                }
                if (node.hasProperty(this.field.getProperty())) {
                    return this.resolveProperty(node);
                }
                logger.debug("Fetch children of type {} from child {}", (Object)nodeType, (Object)this.field.getProperty());
                return this.resolveChildren(node.getNode(this.field.getProperty()), nodeType);
            }
            catch (RepositoryException repositoryException) {
                // empty catch block
            }
        }
        return Stream.empty();
    }
}

