/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.modules.graphql.provider.dxm.sdl.fetchers;

import graphql.Scalars;
import graphql.schema.DataFetchingEnvironment;
import graphql.schema.GraphQLArgument;
import graphql.schema.GraphQLInputType;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.util.Text;
import org.jahia.modules.graphql.provider.dxm.DataFetchingException;
import org.jahia.modules.graphql.provider.dxm.node.GqlJcrNode;
import org.jahia.modules.graphql.provider.dxm.node.SpecializedTypesHandler;
import org.jahia.modules.graphql.provider.dxm.sdl.SDLUtil;
import org.jahia.modules.graphql.provider.dxm.sdl.fetchers.Finder;
import org.jahia.modules.graphql.provider.dxm.sdl.fetchers.FinderListDataFetcher;
import org.jahia.modules.graphql.provider.dxm.sdl.validation.ArgumentValidator;
import org.jahia.modules.graphql.provider.dxm.security.PermissionHelper;
import org.jahia.services.content.JCRNodeIteratorWrapper;
import org.jahia.services.content.JCRSessionWrapper;
import pl.touk.throwing.ThrowingFunction;

public class StringFinderDataFetcher
extends FinderListDataFetcher {
    private static final String CONTAINS = "contains";
    private static final String EQUALS = "equals";
    private static final String INVERT = "invert";

    public StringFinderDataFetcher(Finder finder) {
        super(finder.getType(), finder);
    }

    @Override
    public List<GraphQLArgument> getArguments() {
        List<GraphQLArgument> list = this.getDefaultArguments();
        list.add(GraphQLArgument.newArgument().name(CONTAINS).type((GraphQLInputType)Scalars.GraphQLString).description("Property contains passed parameter").build());
        list.add(GraphQLArgument.newArgument().name(EQUALS).type((GraphQLInputType)Scalars.GraphQLString).description("Property is equal to passed parameter").build());
        list.add(GraphQLArgument.newArgument().name(INVERT).type((GraphQLInputType)Scalars.GraphQLBoolean).description("Inverts 'contains' or 'equals' argument to get either 'not contains' or 'not equals'. Default value is 'false'").defaultValue((Object)false).build());
        return list;
    }

    @Override
    public List<GqlJcrNode> get(DataFetchingEnvironment environment) {
        if (!ArgumentValidator.validate(ArgumentValidator.ArgumentNames.SORT_BY, environment)) {
            return Collections.emptyList();
        }
        return this.getStream(environment).collect(Collectors.toList());
    }

    @Override
    public Stream<GqlJcrNode> getStream(DataFetchingEnvironment environment) {
        if (!ArgumentValidator.validate(ArgumentValidator.ArgumentNames.SORT_BY, environment)) {
            return Stream.empty();
        }
        try {
            String addOn;
            String argument;
            String statement = String.format("SELECT * FROM [%s] as n where n.[%s]=''", this.type, this.finder.getProperty());
            Map<String, Object> arguments = SDLUtil.getArguments(environment);
            boolean invert = (Boolean)arguments.get(INVERT);
            if (!arguments.containsKey(EQUALS) && !arguments.containsKey(CONTAINS)) {
                throw new DataFetchingException(String.format("Entry point %s must have either 'contains' or 'equals' parameter", environment.getFieldDefinition().getName()));
            }
            if (arguments.containsKey(CONTAINS)) {
                argument = Text.escapeIllegalXpathSearchChars((String)((String)arguments.get(CONTAINS)));
                addOn = invert ? "not" : "";
                statement = String.format("SELECT * FROM [%s] as n where %s contains(n.[%s], '%s')", this.type, addOn, this.finder.getProperty(), argument);
            } else if (arguments.containsKey(EQUALS)) {
                argument = Text.escapeIllegalXpathSearchChars((String)((String)arguments.get(EQUALS)));
                addOn = invert ? "<>" : "=";
                statement = String.format("SELECT * FROM [%s] as n where n.[%s]%s'%s'", this.type, this.finder.getProperty(), addOn, argument);
            }
            JCRSessionWrapper currentUserSession = StringFinderDataFetcher.getCurrentUserSession(environment);
            JCRNodeIteratorWrapper it = currentUserSession.getWorkspace().getQueryManager().createQuery(statement, "JCR-SQL2").execute().getNodes();
            Stream<GqlJcrNode> stream = StreamSupport.stream(Spliterators.spliteratorUnknownSize(it, 16), false).filter(node -> PermissionHelper.hasPermission(node, environment)).map(ThrowingFunction.unchecked(SpecializedTypesHandler::getNode));
            return this.resolveCollection(stream, environment);
        }
        catch (RepositoryException e) {
            throw new DataFetchingException(e);
        }
    }
}

