/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.modules.graphql.provider.dxm.sdl.parsing;

import graphql.language.NamedNode;
import graphql.language.NodeParentTree;
import graphql.schema.DataFetcher;
import graphql.schema.GraphQLArgument;
import graphql.schema.GraphQLDirective;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLList;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLOutputType;
import graphql.schema.idl.SchemaDirectiveWiring;
import graphql.schema.idl.SchemaDirectiveWiringEnvironment;
import java.util.List;
import java.util.Map;
import org.jahia.modules.graphql.provider.dxm.sdl.extension.PropertyFetcherExtensionInterface;
import org.jahia.modules.graphql.provider.dxm.sdl.fetchers.Field;
import org.jahia.modules.graphql.provider.dxm.sdl.fetchers.FinderListDataFetcher;
import org.jahia.modules.graphql.provider.dxm.sdl.fetchers.PropertiesDataFetcherFactory;
import org.jahia.modules.graphql.provider.dxm.sdl.fetchers.SDLPaginatedDataConnectionFetcher;
import org.jahia.modules.graphql.provider.dxm.sdl.parsing.ConnectionHelper;
import org.jahia.modules.graphql.provider.dxm.sdl.parsing.SDLSchemaService;
import org.jahia.osgi.BundleUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FetcherDirectiveWiring
implements SchemaDirectiveWiring {
    private static Logger logger = LoggerFactory.getLogger(FetcherDirectiveWiring.class);

    public GraphQLObjectType onObject(SchemaDirectiveWiringEnvironment<GraphQLObjectType> environment) {
        return (GraphQLObjectType)environment.getElement();
    }

    public GraphQLFieldDefinition onField(SchemaDirectiveWiringEnvironment<GraphQLFieldDefinition> environment) {
        GraphQLFieldDefinition def = (GraphQLFieldDefinition)environment.getElement();
        GraphQLDirective directive = environment.getDirective();
        Field field = new Field(def.getName());
        field.setProperty(def.getName());
        field.setType(def.getType().getName());
        DataFetcher typeFetcher = PropertiesDataFetcherFactory.getFetcher(def, field);
        logger.debug("field name {} ", (Object)field.getName());
        logger.debug("field type {} ", (Object)field.getType());
        SDLSchemaService service = (SDLSchemaService)BundleUtils.getOsgiService(SDLSchemaService.class, null);
        if (service != null) {
            Map<String, PropertyFetcherExtensionInterface> fetcherExtensions = service.getPropertyFetcherExtensions();
            String fetcherName = directive.getArgument("name").getValue().toString();
            if (fetcherName != null && fetcherExtensions.containsKey(fetcherName)) {
                typeFetcher = fetcherExtensions.get(fetcherName).getDataFetcher(field);
            }
            String parentType = ((NamedNode)((NodeParentTree)environment.getNodeParentTree().getParentInfo().get()).getNode()).getName();
            String key = parentType + "." + def.getName();
            if (service.getConnectionFieldNameToSDLType().containsKey(key)) {
                ConnectionHelper.ConnectionTypeInfo conInfo = service.getConnectionFieldNameToSDLType().get(key);
                GraphQLOutputType node = (GraphQLOutputType)((GraphQLList)def.getType()).getWrappedType();
                GraphQLObjectType connectionType = ConnectionHelper.getOrCreateConnection(service, node, conInfo.getMappedToType());
                List<GraphQLArgument> args = service.getRelay().getConnectionFieldArguments();
                SDLPaginatedDataConnectionFetcher fetcher = new SDLPaginatedDataConnectionFetcher((FinderListDataFetcher)typeFetcher);
                def.getDirectives().remove(0);
                return GraphQLFieldDefinition.newFieldDefinition((GraphQLFieldDefinition)def).type((GraphQLOutputType)connectionType).dataFetcher(fetcher).argument(args).build();
            }
        }
        return GraphQLFieldDefinition.newFieldDefinition((GraphQLFieldDefinition)def).dataFetcher(typeFetcher).build();
    }
}

