/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.modules.graphql.provider.dxm.security;

import graphql.language.Field;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import org.apache.commons.lang.StringUtils;
import org.jahia.modules.graphql.provider.dxm.DataFetchingException;
import org.jahia.modules.graphql.provider.dxm.security.GqlAccessDeniedException;
import org.jahia.services.content.JCRSessionFactory;
import org.jahia.services.content.JCRSessionWrapper;

public class GqlJcrPermissionChecker {
    public static void checkPermissions(GraphQLType type, List<Field> fields, Map<String, String> permissions) {
        if (permissions == null || permissions.size() == 0 || StringUtils.equals((String)type.getName(), (String)"JCRNodeConnection")) {
            return;
        }
        List<String> types = GqlJcrPermissionChecker.resolveTypes(type);
        try {
            GqlJcrPermissionChecker.checkPermissions(types, fields, permissions, JCRSessionFactory.getInstance().getCurrentUserSession());
        }
        catch (RepositoryException e) {
            throw new DataFetchingException(e);
        }
    }

    public static void checkPermissions(List<String> types, List<Field> fields, Map<String, String> permissions, JCRSessionWrapper session) throws RepositoryException {
        Map<String, String> requiredPermissionPerFields = GqlJcrPermissionChecker.resolvePermissionPerFields(types, fields, permissions);
        if (requiredPermissionPerFields.size() > 0) {
            for (Map.Entry<String, String> requiredPermissionForField : requiredPermissionPerFields.entrySet()) {
                String path = "/";
                String perm = requiredPermissionForField.getValue();
                if (perm.contains("/")) {
                    path = "/" + StringUtils.substringAfter((String)perm, (String)"/");
                    perm = StringUtils.substringBefore((String)perm, (String)"/");
                }
                try {
                    if (session.getNode(path).hasPermission(perm)) continue;
                    throw new GqlAccessDeniedException(perm);
                }
                catch (PathNotFoundException e) {
                    throw new GqlAccessDeniedException(perm);
                }
            }
        }
    }

    private static List<String> resolveTypes(GraphQLType type) {
        GraphQLObjectType objectType;
        ArrayList<String> types = new ArrayList<String>();
        if (type instanceof GraphQLObjectType && (objectType = (GraphQLObjectType)type).getInterfaces().size() > 0) {
            for (GraphQLOutputType graphQLOutputType : objectType.getInterfaces()) {
                types.add(graphQLOutputType.getName());
            }
        }
        types.add(type.getName());
        return types;
    }

    private static Map<String, String> resolvePermissionPerFields(List<String> types, List<Field> fields, Map<String, String> permissions) {
        HashMap<String, String> requiredPermissionForFields = new HashMap<String, String>();
        for (Field field : fields) {
            if (field == null) continue;
            String permission = GqlJcrPermissionChecker.getPermissionForTypes(types, field.getName(), permissions);
            if (permission == null) {
                permission = GqlJcrPermissionChecker.getPermissionForTypes(types, "*", permissions);
            }
            if (permission == null) continue;
            requiredPermissionForFields.put(field.getAlias() != null ? field.getAlias() : field.getName(), permission);
        }
        return requiredPermissionForFields;
    }

    private static String getPermissionForTypes(List<String> types, String field, Map<String, String> permissions) {
        String permission = null;
        for (String type : types) {
            String permissionKey = type + "." + field;
            if (!permissions.containsKey(permissionKey)) continue;
            permission = permissions.get(permissionKey);
        }
        return permission;
    }
}

