/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.modules.graphql.provider.dxm.security;

import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import java.util.Map;
import org.jahia.modules.graphql.provider.dxm.node.GqlJcrNode;
import org.jahia.modules.graphql.provider.dxm.security.GqlAccessDeniedException;
import org.jahia.modules.graphql.provider.dxm.security.GqlJcrPermissionChecker;
import org.jahia.modules.graphql.provider.dxm.security.PermissionHelper;
import org.jahia.services.content.JCRNodeWrapper;

public class GqlJcrPermissionDataFetcher<T>
implements DataFetcher<T> {
    private DataFetcher<T> originalDataFetcher;
    private Map<String, String> permissions;

    public GqlJcrPermissionDataFetcher(DataFetcher<T> originalDataFetcher, Map<String, String> permissions) {
        this.originalDataFetcher = originalDataFetcher;
        this.permissions = permissions;
    }

    public T get(DataFetchingEnvironment environment) throws Exception {
        JCRNodeWrapper jcrNode;
        GqlJcrPermissionChecker.checkPermissions(environment.getParentType(), environment.getFields(), this.permissions);
        if (!PermissionHelper.hasPermission(null, environment)) {
            throw new GqlAccessDeniedException("Access denied");
        }
        Object res = this.originalDataFetcher.get(environment);
        if (res instanceof GqlJcrNode && !PermissionHelper.hasPermission(jcrNode = ((GqlJcrNode)res).getNode(), environment)) {
            throw new GqlAccessDeniedException("Access denied to the node: " + jcrNode.getPath());
        }
        return (T)res;
    }
}

