/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.modules.graphql.provider.dxm.service.vanity;

import graphql.annotations.annotationTypes.GraphQLDescription;
import graphql.annotations.annotationTypes.GraphQLField;
import graphql.annotations.annotationTypes.GraphQLName;
import graphql.annotations.annotationTypes.GraphQLNonNull;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.jahia.exceptions.JahiaRuntimeException;
import org.jahia.modules.graphql.provider.dxm.BaseGqlClientException;
import org.jahia.modules.graphql.provider.dxm.DataFetchingException;
import org.jahia.modules.graphql.provider.dxm.GqlConstraintViolationException;
import org.jahia.modules.graphql.provider.dxm.node.GqlJcrNodeMutation;
import org.jahia.modules.graphql.provider.dxm.node.GqlJcrWrongInputException;
import org.jahia.modules.graphql.provider.dxm.service.vanity.VanityUrlMutationService;
import org.jahia.osgi.BundleUtils;
import org.jahia.services.content.JCRContentUtils;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.seo.VanityUrl;
import org.jahia.services.seo.jcr.VanityUrlService;

@GraphQLName(value="VanityUrlMappingMutation")
public class GqlVanityUrlMappingMutation {
    private JCRNodeWrapper vanityUrlNode;
    private JCRNodeWrapper targetNode;
    private VanityUrlService vanityUrlService;
    private VanityUrlMutationService vanityUrlMutationService;

    public GqlVanityUrlMappingMutation(JCRNodeWrapper vanityUrlNode) {
        try {
            if (!vanityUrlNode.isNodeType("jnt:vanityUrl")) {
                throw new GqlJcrWrongInputException("Vanity URL field can only be used on vanity URL nodes, node: " + vanityUrlNode.getPath() + " is not a vanity URL node");
            }
            this.vanityUrlService = (VanityUrlService)BundleUtils.getOsgiService(VanityUrlService.class, null);
            this.vanityUrlNode = vanityUrlNode;
            this.targetNode = vanityUrlNode.getParent().getParent();
            this.vanityUrlMutationService = new VanityUrlMutationService(this.targetNode, this.vanityUrlService);
        }
        catch (RepositoryException e) {
            throw new JahiaRuntimeException((Throwable)e);
        }
    }

    @GraphQLField
    @GraphQLName(value="uuid")
    @GraphQLDescription(value="Get the identifier of the node currently being mutated")
    public String getUuid() throws BaseGqlClientException {
        try {
            return this.vanityUrlNode.getIdentifier();
        }
        catch (RepositoryException e) {
            throw new DataFetchingException(e);
        }
    }

    @GraphQLField
    @GraphQLDescription(value="Update vanity URL")
    public boolean update(@GraphQLName(value="active") @GraphQLDescription(value="Desired value of the active flag or null to keep existing value") Boolean active, @GraphQLName(value="defaultMapping") @GraphQLDescription(value="Desired value of the default flag or null to keep existing value") Boolean defaultMapping, @GraphQLName(value="language") @GraphQLDescription(value="Desired vanity URL language or null to keep existing value") String language, @GraphQLName(value="url") @GraphQLDescription(value="Desired URL value or null to keep existing value") String url) throws GqlConstraintViolationException {
        try {
            return this.vanityUrlMutationService.update(this.getVanityUrlObject(), active, defaultMapping, language, url);
        }
        catch (RepositoryException e) {
            throw new JahiaRuntimeException((Throwable)e);
        }
    }

    @GraphQLField
    @GraphQLDescription(value="Move the vanity URL to another node")
    public boolean move(@GraphQLName(value="target") @GraphQLNonNull @GraphQLDescription(value="The path of the target node") String target) {
        try {
            JCRNodeWrapper targetMappings;
            JCRNodeWrapper targetNode = this.vanityUrlNode.getSession().getNode(JCRContentUtils.escapeNodePath((String)target));
            if (!targetNode.isNodeType("jmix:vanityUrlMapped")) {
                targetNode.addMixin("jmix:vanityUrlMapped");
            }
            JCRNodeWrapper jCRNodeWrapper = targetMappings = targetNode.hasNode("vanityUrlMapping") ? targetNode.getNode("vanityUrlMapping") : targetNode.addNode("vanityUrlMapping", "jnt:vanityUrls");
            if (!this.vanityUrlNode.getPath().startsWith(targetMappings.getPath())) {
                this.vanityUrlNode.setProperty("j:default", false);
                this.vanityUrlNode.getSession().move(this.vanityUrlNode.getPath(), targetMappings.getPath() + "/" + JCRContentUtils.findAvailableNodeName((Node)targetMappings, (String)this.vanityUrlNode.getName()));
            }
            this.vanityUrlService.flushCaches();
            return true;
        }
        catch (RepositoryException e) {
            throw new JahiaRuntimeException((Throwable)e);
        }
    }

    @GraphQLField
    @GraphQLDescription(value="Deletes the current vanity url")
    public boolean delete() {
        try {
            this.vanityUrlService.removeVanityUrlMapping(this.targetNode, this.getVanityUrlObject());
            return true;
        }
        catch (RepositoryException e) {
            throw new JahiaRuntimeException((Throwable)e);
        }
    }

    @GraphQLField
    @GraphQLName(value="nodeMutation")
    @GraphQLDescription(value="Get mutation on underlying node")
    public GqlJcrNodeMutation getNodeMutation() {
        return new GqlJcrNodeMutation(this.vanityUrlNode);
    }

    private VanityUrl getVanityUrlObject() throws RepositoryException {
        List vanityUrls = this.vanityUrlService.getVanityUrls(this.targetNode, null, this.vanityUrlNode.getSession());
        for (VanityUrl vanityUrl : vanityUrls) {
            if (!vanityUrl.getIdentifier().equals(this.vanityUrlNode.getIdentifier())) continue;
            return vanityUrl;
        }
        throw new IllegalStateException("Vanity URL node not found by UUID: " + this.vanityUrlNode.getIdentifier());
    }
}

