/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.modules.graphql.provider.dxm.service.vanity;

import graphql.annotations.annotationTypes.GraphQLDescription;
import graphql.annotations.annotationTypes.GraphQLField;
import graphql.annotations.annotationTypes.GraphQLName;
import graphql.annotations.annotationTypes.GraphQLTypeExtension;
import graphql.schema.DataFetchingEnvironment;
import java.util.Collection;
import java.util.Collections;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.jcr.RepositoryException;
import org.jahia.modules.graphql.provider.dxm.node.GqlJcrNode;
import org.jahia.modules.graphql.provider.dxm.predicate.FieldEvaluator;
import org.jahia.modules.graphql.provider.dxm.predicate.FieldFiltersInput;
import org.jahia.modules.graphql.provider.dxm.predicate.FilterHelper;
import org.jahia.modules.graphql.provider.dxm.service.vanity.GqlJcrVanityUrl;
import org.jahia.services.content.JCRNodeIteratorWrapper;

@GraphQLTypeExtension(value=GqlJcrNode.class)
@GraphQLDescription(value="Node extension for vanity URL")
public class VanityUrlJCRNodeExtensions {
    private GqlJcrNode node;

    public VanityUrlJCRNodeExtensions(GqlJcrNode node) {
        this.node = node;
    }

    @GraphQLField
    @GraphQLName(value="vanityUrls")
    @GraphQLDescription(value="Get vanity URLs from the current node filtered by the parameters")
    public Collection<GqlJcrVanityUrl> getVanityUrls(@GraphQLName(value="languages") @GraphQLDescription(value="Languages") Collection<String> languages, @GraphQLName(value="fieldFilter") @GraphQLDescription(value="Filter results based on graphql field values") FieldFiltersInput fieldFilter, DataFetchingEnvironment environment) {
        JCRNodeIteratorWrapper vanityUrls;
        try {
            if (!this.node.getNode().hasNode("vanityUrlMapping")) {
                return Collections.emptyList();
            }
            vanityUrls = this.node.getNode().getNode("vanityUrlMapping").getNodes();
        }
        catch (RepositoryException e) {
            throw new RuntimeException(e);
        }
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(vanityUrls, 16), false).map(GqlJcrVanityUrl::new).filter(gqlJcrVanityUrl -> languages == null || languages.contains(gqlJcrVanityUrl.getLanguage())).filter(FilterHelper.getFieldPredicate(fieldFilter, FieldEvaluator.forList(environment))).collect(Collectors.toList());
    }
}

