/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.modules.graphql.provider.dxm.site;

import graphql.annotations.annotationTypes.GraphQLDescription;
import graphql.annotations.annotationTypes.GraphQLField;
import graphql.annotations.annotationTypes.GraphQLName;
import graphql.annotations.annotationTypes.GraphQLTypeExtension;
import javax.jcr.RepositoryException;
import org.jahia.modules.graphql.provider.dxm.node.GqlJcrNode;
import org.jahia.modules.graphql.provider.dxm.site.GqlJcrSite;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.decorator.JCRSiteNode;

@GraphQLTypeExtension(value=GqlJcrNode.class)
@GraphQLDescription(value="Extension for the JCR site node")
public class SiteJCRNodeExtensions {
    private GqlJcrNode node;

    public SiteJCRNodeExtensions(GqlJcrNode node) {
        this.node = node;
    }

    @GraphQLField
    @GraphQLName(value="site")
    @GraphQLDescription(value="GraphQL representation of the site the JCR node belongs to, or the system site in case the node does not belong to any site")
    public GqlJcrSite getSite() {
        try {
            JCRSiteNode resolveSite = this.node.getNode().getResolveSite();
            if (resolveSite == null) {
                return null;
            }
            return new GqlJcrSite((JCRNodeWrapper)resolveSite);
        }
        catch (RepositoryException e) {
            throw new RuntimeException(e);
        }
    }
}

