/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.modules.graphql.provider.dxm.upload;

import graphql.kickstart.servlet.context.GraphQLServletContext;
import graphql.schema.DataFetchingEnvironment;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.Part;
import org.apache.commons.fileupload.FileUploadBase;
import org.jahia.modules.graphql.provider.dxm.node.GqlJcrWrongInputException;
import org.jahia.settings.SettingsBean;

public class UploadHelper {
    public static boolean isValidFileUpload(String name, DataFetchingEnvironment environment) throws FileUploadBase.FileSizeLimitExceededException {
        long maxUploadSize;
        GraphQLServletContext context = (GraphQLServletContext)environment.getContext();
        if (context.getParts().isEmpty()) {
            return false;
        }
        Part part = UploadHelper.getPartForName(context, name);
        if (part == null) {
            return false;
        }
        long uploadSize = part.getSize();
        if (uploadSize > (maxUploadSize = SettingsBean.getInstance().getJahiaFileUploadMaxSize())) {
            throw new FileUploadBase.FileSizeLimitExceededException(String.format("The field %s exceeds its maximum permitted size of %s bytes.", part.getName(), maxUploadSize), uploadSize, maxUploadSize);
        }
        return true;
    }

    public static Part getFileUpload(String name, DataFetchingEnvironment environment) {
        if (!(environment.getContext() instanceof GraphQLServletContext)) {
            throw new GqlJcrWrongInputException("Not a servlet context");
        }
        GraphQLServletContext context = (GraphQLServletContext)environment.getContext();
        if (context.getParts().isEmpty()) {
            throw new GqlJcrWrongInputException("Must use multipart request");
        }
        Part part = UploadHelper.getPartForName(context, name);
        if (part == null) {
            throw new GqlJcrWrongInputException("Must send file as multipart request for " + name);
        }
        return part;
    }

    private static Part getPartForName(GraphQLServletContext context, String name) {
        List parts = context.getFileParts().stream().filter(part -> name.equals(part.getName())).collect(Collectors.toList());
        return parts.isEmpty() || parts.size() > 1 ? null : (Part)parts.get(0);
    }
}

