/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.modules.graphql.provider.dxm.user;

import graphql.annotations.annotationTypes.GraphQLDescription;
import graphql.annotations.annotationTypes.GraphQLField;
import graphql.annotations.annotationTypes.GraphQLName;
import graphql.annotations.annotationTypes.GraphQLNonNull;
import graphql.annotations.connection.GraphQLConnection;
import graphql.schema.DataFetchingEnvironment;
import java.util.Objects;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.jcr.RepositoryException;
import org.jahia.data.viewhelper.principal.PrincipalViewHelper;
import org.jahia.modules.graphql.provider.dxm.node.GqlJcrNode;
import org.jahia.modules.graphql.provider.dxm.node.SpecializedTypesHandler;
import org.jahia.modules.graphql.provider.dxm.osgi.annotations.GraphQLOsgiService;
import org.jahia.modules.graphql.provider.dxm.predicate.FieldEvaluator;
import org.jahia.modules.graphql.provider.dxm.predicate.FieldFiltersInput;
import org.jahia.modules.graphql.provider.dxm.predicate.FieldGroupingInput;
import org.jahia.modules.graphql.provider.dxm.predicate.FieldSorterInput;
import org.jahia.modules.graphql.provider.dxm.predicate.FilterHelper;
import org.jahia.modules.graphql.provider.dxm.predicate.GroupingHelper;
import org.jahia.modules.graphql.provider.dxm.predicate.SorterHelper;
import org.jahia.modules.graphql.provider.dxm.relay.DXPaginatedData;
import org.jahia.modules.graphql.provider.dxm.relay.DXPaginatedDataConnectionFetcher;
import org.jahia.modules.graphql.provider.dxm.relay.PaginationHelper;
import org.jahia.modules.graphql.provider.dxm.site.GqlJcrSite;
import org.jahia.modules.graphql.provider.dxm.user.GqlPrincipal;
import org.jahia.modules.graphql.provider.dxm.user.GqlUser;
import org.jahia.modules.graphql.provider.dxm.user.PrincipalType;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRSessionFactory;
import org.jahia.services.content.decorator.JCRGroupNode;
import org.jahia.services.content.decorator.JCRUserNode;
import org.jahia.services.usermanager.JahiaGroup;
import org.jahia.services.usermanager.JahiaGroupManagerService;

@GraphQLName(value="Group")
@GraphQLDescription(value="GraphQL representation of a Jahia group")
public class GqlGroup
implements GqlPrincipal {
    private final JahiaGroup group;
    @Inject
    @GraphQLOsgiService
    private JahiaGroupManagerService groupManagerService;
    @Inject
    @GraphQLOsgiService
    private JCRSessionFactory jcrSessionFactory;

    public GqlGroup(JahiaGroup jahiaGroup) {
        this.group = jahiaGroup;
    }

    @Override
    @GraphQLField
    @GraphQLNonNull
    @GraphQLDescription(value="Group name")
    public String getName() {
        return this.group.getName();
    }

    @Override
    @GraphQLField
    @GraphQLDescription(value="Full display name")
    public String getDisplayName() {
        return PrincipalViewHelper.getFullName((Object)this.group);
    }

    @GraphQLField
    @GraphQLDescription(value="Group property")
    public String getProperty(@GraphQLName(value="name") @GraphQLNonNull @GraphQLDescription(value="The name of the property") String name) {
        return this.group.getProperty(name);
    }

    @Override
    @GraphQLField
    @GraphQLDescription(value="Site where the group is defined")
    public GqlJcrSite getSite() throws RepositoryException {
        return new GqlJcrSite((JCRNodeWrapper)this.jcrSessionFactory.getCurrentUserSession().getNode(this.group.getLocalPath()).getResolveSite());
    }

    @GraphQLField
    @GraphQLNonNull
    @GraphQLDescription(value="Group members")
    @GraphQLConnection(connectionFetcher=DXPaginatedDataConnectionFetcher.class)
    public DXPaginatedData<GqlPrincipal> getMembers(@GraphQLName(value="fieldFilter") @GraphQLDescription(value="Filter by graphQL fields values") FieldFiltersInput fieldFilter, @GraphQLName(value="fieldSorter") @GraphQLDescription(value="Sort by graphQL fields values") FieldSorterInput fieldSorter, @GraphQLName(value="fieldGrouping") @GraphQLDescription(value="Group fields according to specified criteria") FieldGroupingInput fieldGrouping, DataFetchingEnvironment environment) {
        Stream<Object> stream = this.groupManagerService.lookupGroupByPath(this.group.getLocalPath()).getMembers().stream().map(this::convertMember).filter(Objects::nonNull).filter(FilterHelper.getFieldPredicate(fieldFilter, FieldEvaluator.forConnection(environment)));
        if (fieldSorter != null) {
            stream = stream.sorted(SorterHelper.getFieldComparator(fieldSorter, FieldEvaluator.forConnection(environment)));
        }
        if (fieldGrouping != null) {
            stream = GroupingHelper.group(stream, fieldGrouping, FieldEvaluator.forConnection(environment));
        }
        PaginationHelper.Arguments arguments = PaginationHelper.parseArguments(environment);
        return PaginationHelper.paginate(stream, n -> PaginationHelper.encodeCursor(n.getName()), arguments);
    }

    private GqlPrincipal convertMember(JCRNodeWrapper node) {
        if (node instanceof JCRUserNode) {
            return new GqlUser(((JCRUserNode)node).getJahiaUser());
        }
        if (node instanceof JCRGroupNode) {
            return new GqlGroup(((JCRGroupNode)node).getJahiaGroup());
        }
        return null;
    }

    @Override
    @GraphQLField
    @GraphQLDescription(value="Is this principal member of the specified group")
    public boolean isMemberOf(@GraphQLName(value="group") @GraphQLDescription(value="Target group") String group, @GraphQLName(value="site") @GraphQLDescription(value="Site where the group is defined") String site) {
        JCRGroupNode groupNode = this.groupManagerService.lookupGroup(site, group);
        if (groupNode == null) {
            return false;
        }
        return groupNode.isMember(this.group.getLocalPath());
    }

    @Override
    @GraphQLField
    @GraphQLNonNull
    @GraphQLDescription(value="List of groups this principal belongs to")
    @GraphQLConnection(connectionFetcher=DXPaginatedDataConnectionFetcher.class)
    public DXPaginatedData<GqlGroup> getGroupMembership(@GraphQLName(value="site") @GraphQLDescription(value="Return only groups which belong to this site") String site, @GraphQLName(value="fieldFilter") @GraphQLDescription(value="Filter by graphQL fields values") FieldFiltersInput fieldFilter, @GraphQLName(value="fieldSorter") @GraphQLDescription(value="Sort by graphQL fields values") FieldSorterInput fieldSorter, @GraphQLName(value="fieldGrouping") @GraphQLDescription(value="Group fields according to specified criteria") FieldGroupingInput fieldGrouping, DataFetchingEnvironment environment) {
        return GqlPrincipal.getGroupMembership(this.group.getLocalPath(), site, fieldFilter, fieldSorter, fieldGrouping, environment, this.groupManagerService);
    }

    @Override
    @GraphQLField
    @GraphQLDescription(value="Get the corresponding JCR node")
    public GqlJcrNode getNode() throws RepositoryException {
        return SpecializedTypesHandler.getNode(this.jcrSessionFactory.getCurrentUserSession().getNode(this.group.getLocalPath()));
    }

    @Override
    @GraphQLField
    @GraphQLDescription(value="Return GROUP principal type")
    public PrincipalType getPrincipalType() {
        return PrincipalType.GROUP;
    }
}

