/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.modules.graphql.provider.dxm.user;

import graphql.annotations.annotationTypes.GraphQLDescription;
import graphql.annotations.annotationTypes.GraphQLField;
import graphql.annotations.annotationTypes.GraphQLName;
import graphql.annotations.annotationTypes.GraphQLNonNull;
import graphql.annotations.annotationTypes.GraphQLTypeResolver;
import graphql.annotations.connection.GraphQLConnection;
import graphql.schema.DataFetchingEnvironment;
import java.util.List;
import java.util.stream.Stream;
import javax.jcr.RepositoryException;
import org.jahia.modules.graphql.provider.dxm.node.GqlJcrNode;
import org.jahia.modules.graphql.provider.dxm.predicate.FieldEvaluator;
import org.jahia.modules.graphql.provider.dxm.predicate.FieldFiltersInput;
import org.jahia.modules.graphql.provider.dxm.predicate.FieldGroupingInput;
import org.jahia.modules.graphql.provider.dxm.predicate.FieldSorterInput;
import org.jahia.modules.graphql.provider.dxm.predicate.FilterHelper;
import org.jahia.modules.graphql.provider.dxm.predicate.GroupingHelper;
import org.jahia.modules.graphql.provider.dxm.predicate.SorterHelper;
import org.jahia.modules.graphql.provider.dxm.relay.DXPaginatedData;
import org.jahia.modules.graphql.provider.dxm.relay.DXPaginatedDataConnectionFetcher;
import org.jahia.modules.graphql.provider.dxm.relay.PaginationHelper;
import org.jahia.modules.graphql.provider.dxm.site.GqlJcrSite;
import org.jahia.modules.graphql.provider.dxm.user.GqlGroup;
import org.jahia.modules.graphql.provider.dxm.user.PrincipalType;
import org.jahia.modules.graphql.provider.dxm.user.PrincipalTypeResolver;
import org.jahia.services.usermanager.JahiaGroupManagerService;
import pl.touk.throwing.ThrowingPredicate;

@GraphQLName(value="Principal")
@GraphQLDescription(value="GraphQL representation of a principal")
@GraphQLTypeResolver(value=PrincipalTypeResolver.class)
public interface GqlPrincipal {
    public static DXPaginatedData<GqlGroup> getGroupMembership(String localPath, String site, FieldFiltersInput fieldFilter, FieldSorterInput fieldSorter, FieldGroupingInput fieldGrouping, DataFetchingEnvironment environment, JahiaGroupManagerService groupManagerService) {
        List paths = groupManagerService.getMembershipByPath(localPath);
        Stream<Object> stream = paths.stream().map(path -> groupManagerService.lookupGroupByPath(path).getJahiaGroup()).filter(group -> !group.isHidden()).filter(ThrowingPredicate.unchecked(n -> site == null || n.getLocalPath().startsWith("/sites/" + site + "/"))).map(GqlGroup::new).filter(FilterHelper.getFieldPredicate(fieldFilter, FieldEvaluator.forConnection(environment)));
        if (fieldSorter != null) {
            stream = stream.sorted(SorterHelper.getFieldComparator(fieldSorter, FieldEvaluator.forConnection(environment)));
        }
        if (fieldGrouping != null) {
            stream = GroupingHelper.group(stream, fieldGrouping, FieldEvaluator.forConnection(environment));
        }
        PaginationHelper.Arguments arguments = PaginationHelper.parseArguments(environment);
        return PaginationHelper.paginate(stream, n -> PaginationHelper.encodeCursor(n.getName()), arguments);
    }

    @GraphQLField
    @GraphQLNonNull
    @GraphQLDescription(value="Name")
    public String getName();

    @GraphQLField
    @GraphQLDescription(value="Full display name")
    public String getDisplayName();

    @GraphQLField
    @GraphQLDescription(value="Site where the principal is defined")
    public GqlJcrSite getSite() throws RepositoryException;

    @GraphQLField
    @GraphQLDescription(value="Is this principal member of the specified group")
    public boolean isMemberOf(@GraphQLName(value="group") @GraphQLDescription(value="Target group") String var1, @GraphQLName(value="site") @GraphQLDescription(value="Site where the group is defined") String var2);

    @GraphQLField
    @GraphQLNonNull
    @GraphQLDescription(value="List of groups this principal belongs to")
    @GraphQLConnection(connectionFetcher=DXPaginatedDataConnectionFetcher.class)
    public DXPaginatedData<GqlGroup> getGroupMembership(@GraphQLName(value="site") @GraphQLDescription(value="Return only groups which belong to this site") String var1, @GraphQLName(value="fieldFilter") @GraphQLDescription(value="Filter by graphQL fields values") FieldFiltersInput var2, @GraphQLName(value="fieldSorter") @GraphQLDescription(value="Sort by graphQL fields values") FieldSorterInput var3, @GraphQLName(value="fieldGrouping") @GraphQLDescription(value="Group fields according to specified criteria") FieldGroupingInput var4, DataFetchingEnvironment var5);

    @GraphQLField
    @GraphQLDescription(value="Get the corresponding JCR node")
    public GqlJcrNode getNode() throws RepositoryException;

    @GraphQLField
    @GraphQLDescription(value="Get principal type for this principal")
    public PrincipalType getPrincipalType();
}

