/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.modules.graphql.provider.dxm.user;

import graphql.annotations.annotationTypes.GraphQLDeprecate;
import graphql.annotations.annotationTypes.GraphQLDescription;
import graphql.annotations.annotationTypes.GraphQLField;
import graphql.annotations.annotationTypes.GraphQLName;
import graphql.annotations.annotationTypes.GraphQLNonNull;
import graphql.annotations.connection.GraphQLConnection;
import graphql.schema.DataFetchingEnvironment;
import javax.inject.Inject;
import javax.jcr.RepositoryException;
import org.jahia.data.viewhelper.principal.PrincipalViewHelper;
import org.jahia.modules.graphql.provider.dxm.node.GqlJcrNode;
import org.jahia.modules.graphql.provider.dxm.node.SpecializedTypesHandler;
import org.jahia.modules.graphql.provider.dxm.osgi.annotations.GraphQLOsgiService;
import org.jahia.modules.graphql.provider.dxm.predicate.FieldFiltersInput;
import org.jahia.modules.graphql.provider.dxm.predicate.FieldGroupingInput;
import org.jahia.modules.graphql.provider.dxm.predicate.FieldSorterInput;
import org.jahia.modules.graphql.provider.dxm.relay.DXPaginatedData;
import org.jahia.modules.graphql.provider.dxm.relay.DXPaginatedDataConnectionFetcher;
import org.jahia.modules.graphql.provider.dxm.site.GqlJcrSite;
import org.jahia.modules.graphql.provider.dxm.user.GqlGroup;
import org.jahia.modules.graphql.provider.dxm.user.GqlPrincipal;
import org.jahia.modules.graphql.provider.dxm.user.PrincipalType;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRSessionFactory;
import org.jahia.services.content.decorator.JCRGroupNode;
import org.jahia.services.usermanager.JahiaGroupManagerService;
import org.jahia.services.usermanager.JahiaUser;

@GraphQLName(value="User")
@GraphQLDescription(value="GraphQL representation of a Jahia user")
public class GqlUser
implements GqlPrincipal {
    private final JahiaUser user;
    @Inject
    @GraphQLOsgiService
    private JahiaGroupManagerService groupManagerService;
    @Inject
    @GraphQLOsgiService
    private JCRSessionFactory jcrSessionFactory;

    public GqlUser(JahiaUser jahiaUser) {
        this.user = jahiaUser;
    }

    @Override
    @GraphQLField
    @GraphQLNonNull
    @GraphQLDeprecate
    @GraphQLDescription(value="User name")
    public String getName() {
        return this.user.getName();
    }

    @GraphQLField
    @GraphQLNonNull
    @GraphQLDescription(value="Username of the user")
    public String getUsername() {
        return this.user.getName();
    }

    @GraphQLField
    @GraphQLDescription(value="First name of the user")
    public String getFirstname() {
        return this.user.getProperty("j:firstName");
    }

    @GraphQLField
    @GraphQLDescription(value="Last name of the user")
    public String getLastname() {
        return this.user.getProperty("j:lastName");
    }

    @GraphQLField
    @GraphQLDescription(value="Email of the user")
    public String getEmail() {
        return this.user.getProperty("j:email");
    }

    @GraphQLField
    @GraphQLDescription(value="User organization")
    public String getOrganization() {
        return this.user.getProperty("j:organization");
    }

    @GraphQLField
    @GraphQLDescription(value="Preferred language by the user")
    public String getLanguage() {
        return this.user.getProperty("preferredLanguage");
    }

    @GraphQLField
    @GraphQLDescription(value="Displays if user is locked")
    public boolean getLocked() {
        return Boolean.parseBoolean(this.user.getProperty("j:accountLocked"));
    }

    @Override
    @GraphQLField
    @GraphQLDescription(value="Full display name")
    public String getDisplayName() {
        return PrincipalViewHelper.getFullName((Object)this.user);
    }

    @GraphQLField
    @GraphQLDescription(value="User property")
    public String getProperty(@GraphQLName(value="name") @GraphQLNonNull @GraphQLDescription(value="The name of the property") String name) {
        return this.user.getProperty(name);
    }

    @Override
    @GraphQLField
    @GraphQLDescription(value="Site where the user is defined")
    public GqlJcrSite getSite() throws RepositoryException {
        return new GqlJcrSite((JCRNodeWrapper)this.jcrSessionFactory.getCurrentUserSession().getNode(this.user.getLocalPath()).getResolveSite());
    }

    @Override
    @GraphQLField
    @GraphQLDescription(value="Is this principal member of the specified group")
    public boolean isMemberOf(@GraphQLName(value="group") @GraphQLDescription(value="Target group") String group, @GraphQLName(value="site") @GraphQLDescription(value="Site where the group is defined") String site) {
        JCRGroupNode groupNode = this.groupManagerService.lookupGroup(site, group);
        if (groupNode == null) {
            return false;
        }
        return groupNode.isMember(this.user.getLocalPath());
    }

    @Override
    @GraphQLField
    @GraphQLNonNull
    @GraphQLDescription(value="List of groups this principal belongs to")
    @GraphQLConnection(connectionFetcher=DXPaginatedDataConnectionFetcher.class)
    public DXPaginatedData<GqlGroup> getGroupMembership(@GraphQLName(value="site") @GraphQLDescription(value="Return only groups which belong to this site") String site, @GraphQLName(value="fieldFilter") @GraphQLDescription(value="Filter by graphQL fields values") FieldFiltersInput fieldFilter, @GraphQLName(value="fieldSorter") @GraphQLDescription(value="Sort by graphQL fields values") FieldSorterInput fieldSorter, @GraphQLName(value="fieldGrouping") @GraphQLDescription(value="Group fields according to specified criteria") FieldGroupingInput fieldGrouping, DataFetchingEnvironment environment) {
        return GqlPrincipal.getGroupMembership(this.user.getLocalPath(), site, fieldFilter, fieldSorter, fieldGrouping, environment, this.groupManagerService);
    }

    @Override
    @GraphQLField
    @GraphQLDescription(value="Get the corresponding JCR node")
    public GqlJcrNode getNode() throws RepositoryException {
        return SpecializedTypesHandler.getNode(this.jcrSessionFactory.getCurrentUserSession().getNode(this.user.getLocalPath()));
    }

    @Override
    @GraphQLField
    @GraphQLDescription(value="Return USER principal type")
    public PrincipalType getPrincipalType() {
        return PrincipalType.USER;
    }
}

