/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.modules.graphql.provider.dxm.user;

import graphql.annotations.annotationTypes.GraphQLDescription;
import graphql.annotations.annotationTypes.GraphQLField;
import graphql.annotations.annotationTypes.GraphQLName;
import graphql.annotations.annotationTypes.GraphQLNonNull;
import graphql.annotations.connection.GraphQLConnection;
import graphql.schema.DataFetchingEnvironment;
import java.util.stream.Stream;
import javax.inject.Inject;
import org.jahia.modules.graphql.provider.dxm.osgi.annotations.GraphQLOsgiService;
import org.jahia.modules.graphql.provider.dxm.predicate.FieldEvaluator;
import org.jahia.modules.graphql.provider.dxm.predicate.FieldFiltersInput;
import org.jahia.modules.graphql.provider.dxm.predicate.FieldGroupingInput;
import org.jahia.modules.graphql.provider.dxm.predicate.FieldSorterInput;
import org.jahia.modules.graphql.provider.dxm.predicate.FilterHelper;
import org.jahia.modules.graphql.provider.dxm.predicate.GroupingHelper;
import org.jahia.modules.graphql.provider.dxm.predicate.SorterHelper;
import org.jahia.modules.graphql.provider.dxm.relay.DXPaginatedData;
import org.jahia.modules.graphql.provider.dxm.relay.DXPaginatedDataConnectionFetcher;
import org.jahia.modules.graphql.provider.dxm.relay.PaginationHelper;
import org.jahia.modules.graphql.provider.dxm.user.GqlUser;
import org.jahia.services.content.decorator.JCRUserNode;
import org.jahia.services.usermanager.JahiaUserManagerService;

@GraphQLName(value="UserAdminQuery")
@GraphQLDescription(value="User admin queries")
public class GqlUserAdmin {
    @Inject
    @GraphQLOsgiService
    private JahiaUserManagerService userManagerService;

    @GraphQLField
    @GraphQLDescription(value="Get a user")
    public GqlUser getUser(@GraphQLName(value="username") @GraphQLDescription(value="User name") @GraphQLNonNull String userName, @GraphQLName(value="site") @GraphQLDescription(value="Site where the user is defined") String site) {
        JCRUserNode jcrUserNode = this.userManagerService.lookupUser(userName, site);
        if (jcrUserNode == null) {
            return null;
        }
        return new GqlUser(jcrUserNode.getJahiaUser());
    }

    @GraphQLField
    @GraphQLDescription(value="Get users list")
    @GraphQLConnection(connectionFetcher=DXPaginatedDataConnectionFetcher.class)
    public DXPaginatedData<GqlUser> getUsers(@GraphQLName(value="fieldFilter") @GraphQLDescription(value="Filter by graphQL fields values") FieldFiltersInput fieldFilter, @GraphQLName(value="fieldSorter") @GraphQLDescription(value="Sort by graphQL fields values") FieldSorterInput fieldSorter, @GraphQLName(value="fieldGrouping") @GraphQLDescription(value="Group fields according to specified criteria") FieldGroupingInput fieldGrouping, DataFetchingEnvironment environment) {
        Stream<Object> userStream = this.userManagerService.searchUsers(null).stream().map(user -> new GqlUser(user.getJahiaUser())).filter(FilterHelper.getFieldPredicate(fieldFilter, FieldEvaluator.forConnection(environment)));
        if (fieldSorter != null) {
            userStream = userStream.sorted(SorterHelper.getFieldComparator(fieldSorter, FieldEvaluator.forConnection(environment)));
        }
        if (fieldGrouping != null) {
            userStream = GroupingHelper.group(userStream, fieldGrouping, FieldEvaluator.forConnection(environment));
        }
        PaginationHelper.Arguments arguments = PaginationHelper.parseArguments(environment);
        return PaginationHelper.paginate(userStream, n -> PaginationHelper.encodeCursor(n.getName()), arguments);
    }
}

