/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.modules.graphql.provider.dxm.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.jcr.Binary;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.jackrabbit.spi.commons.conversion.MalformedPathException;
import org.apache.jackrabbit.value.BinaryImpl;
import org.apache.tika.Tika;
import org.jahia.modules.graphql.provider.dxm.DataFetchingException;
import org.jahia.services.content.JCRContentUtils;
import org.jahia.services.content.JCRNodeIteratorWrapper;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRSessionFactory;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.decorator.JCRFileContent;
import org.jahia.settings.SettingsBean;
import org.jahia.utils.zip.ZipEntryCharsetDetector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZipUtils {
    private static final Logger logger = LoggerFactory.getLogger(ZipUtils.class);
    private static final Tika TIKA = new Tika();
    static final int BUFFER = 512;
    static final long MAX_SIZE = 0x6400000L;
    static final int MAX_ENTRIES = 1024;

    private ZipUtils() {
    }

    public static void addToZip(List<JCRNodeWrapper> nodes, JCRNodeWrapper file) {
        String filename = file.getName();
        File tmp = null;
        try {
            tmp = File.createTempFile(filename, "");
            try (ZipOutputStream zout = new ZipOutputStream(new FileOutputStream(tmp));){
                if (file.hasNode("jcr:content") && file.getNode("jcr:content").hasProperty("jcr:data")) {
                    try (ZipInputStream zin = new ZipInputStream(file.getFileContent().downloadFile());){
                        ZipEntry entry = zin.getNextEntry();
                        while (entry != null) {
                            zout.putNextEntry(entry);
                            IOUtils.copy((InputStream)zin, (OutputStream)zout);
                            entry = zin.getNextEntry();
                        }
                    }
                } else {
                    file.addNode("jcr:content", "jnt:resource");
                }
                for (JCRNodeWrapper node : nodes) {
                    ZipUtils.zip(node, zout, "");
                }
            }
            var5_6 = null;
            try (BufferedInputStream is = new BufferedInputStream(new FileInputStream(tmp));){
                file.getNode("jcr:content").setProperty("jcr:data", (Binary)new BinaryImpl((InputStream)is));
            }
            catch (Throwable throwable) {
                var5_6 = throwable;
                throw throwable;
            }
            file.getNode("jcr:content").setProperty("jcr:mimeType", "application/zip");
        }
        catch (IOException | RepositoryException e) {
            throw new DataFetchingException(e);
        }
        finally {
            FileUtils.deleteQuietly((File)tmp);
        }
    }

    private static String validateFilename(String filename) throws IOException {
        String canonicalID;
        String canonicalPath = new File(filename).getCanonicalPath();
        if (canonicalPath.startsWith(canonicalID = new File(".").getCanonicalPath()) && canonicalPath.length() > canonicalID.length()) {
            return canonicalPath.substring(canonicalID.length() + 1);
        }
        throw new IllegalStateException("File is outside extraction target directory.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void unzip(JCRNodeWrapper dest, JCRNodeWrapper zipFile) {
        long maxSize = SettingsBean.getInstance().getLong("zipFile.maxSize", 0x6400000L);
        int maxEntries = SettingsBean.getInstance().getInt("zipFile.maxEntriesCount", 1024);
        JCRFileContent fileContent = zipFile.getFileContent();
        Charset charset = ZipEntryCharsetDetector.detect((JCRFileContent)fileContent);
        File zipTmpFile = null;
        ZipFile zip = null;
        try (InputStream is = fileContent.downloadFile();){
            zipTmpFile = File.createTempFile("zipfile", ".zip");
            FileUtils.copyInputStreamToFile((InputStream)is, (File)zipTmpFile);
            zip = new ZipFile(zipTmpFile, charset);
            int entries = 0;
            long total = 0L;
            Enumeration<? extends ZipEntry> enumeration = zip.entries();
            while (enumeration.hasMoreElements()) {
                ZipEntry zipEntry = enumeration.nextElement();
                try {
                    int count;
                    JCRSessionWrapper currentUserSession = JCRSessionFactory.getInstance().getCurrentUserSession("default");
                    String filename = zipEntry.getName().replace('\\', '/');
                    ZipUtils.validateFilename(filename);
                    if (filename.endsWith("/")) {
                        filename = filename.substring(0, filename.length() - 1);
                    }
                    int endIndex = filename.lastIndexOf(47);
                    String parentName = dest.getPath();
                    if (endIndex > -1) {
                        parentName = parentName + "/" + filename.substring(0, endIndex);
                        filename = filename.substring(endIndex + 1);
                    }
                    JCRNodeWrapper target = ZipUtils.ensureDir(parentName, currentUserSession);
                    if (zipEntry.isDirectory()) {
                        String folderName = JCRContentUtils.escapeLocalNodeName((String)filename);
                        if (target.hasNode(folderName)) continue;
                        target.addNode(folderName, "jnt:folder");
                        continue;
                    }
                    byte[] data = new byte[512];
                    File unzippedTmpFile = File.createTempFile("unzipped", "");
                    BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(unzippedTmpFile), 512);
                    InputStream zis = zip.getInputStream(zipEntry);
                    while (total + 512L <= maxSize && (count = zis.read(data, 0, 512)) != -1) {
                        bos.write(data, 0, count);
                        total += (long)count;
                    }
                    bos.close();
                    if (++entries > maxEntries) {
                        throw new IllegalStateException("Too many files to unzip.");
                    }
                    if (total + 512L > maxSize) {
                        throw new IllegalStateException("File being unzipped is too big.");
                    }
                    try {
                        InputStream inputStream = Files.newInputStream(unzippedTmpFile.toPath(), new OpenOption[0]);
                        Throwable throwable = null;
                        try {
                            target.uploadFile(filename, inputStream, ZipUtils.getMimeType(zipEntry.getName(), inputStream));
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (inputStream == null) continue;
                            if (throwable != null) {
                                try {
                                    inputStream.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                                continue;
                            }
                            inputStream.close();
                        }
                    }
                    finally {
                        Files.delete(unzippedTmpFile.toPath());
                    }
                }
                catch (IOException | RepositoryException e) {
                    logger.error("Failed to process zip entry during unzip", e);
                }
            }
        }
        catch (IOException e) {
            try {
                throw new DataFetchingException(e);
            }
            catch (Throwable throwable) {
                FileUtils.deleteQuietly(zipTmpFile);
                try {
                    if (zip == null) throw throwable;
                    zip.close();
                    throw throwable;
                }
                catch (IOException e2) {
                    logger.error("Failed to close zip stream", (Throwable)e2);
                }
                throw throwable;
            }
        }
        FileUtils.deleteQuietly((File)zipTmpFile);
        try {
            if (zip == null) return;
            zip.close();
            return;
        }
        catch (IOException e) {
            logger.error("Failed to close zip stream", (Throwable)e);
            return;
        }
    }

    private static void zip(JCRNodeWrapper node, ZipOutputStream zout, String parent) throws RepositoryException {
        block17: {
            try {
                if (node.isNodeType("jnt:file")) {
                    try (InputStream inputStream = node.getFileContent().downloadFile();){
                        zout.putNextEntry(new ZipEntry(parent + node.getName()));
                        IOUtils.copy((InputStream)inputStream, (OutputStream)zout);
                        zout.closeEntry();
                        break block17;
                    }
                }
                if (node.isNodeType("jnt:folder")) {
                    parent = parent + node.getName() + "/";
                    zout.putNextEntry(new ZipEntry(parent));
                    JCRNodeIteratorWrapper it = node.getNodes();
                    while (it.hasNext()) {
                        JCRNodeWrapper n = (JCRNodeWrapper)it.next();
                        ZipUtils.zip(n, zout, parent);
                    }
                }
            }
            catch (IOException e) {
                throw new DataFetchingException(e);
            }
        }
    }

    public static String getMimeType(String name, InputStream inputStream) throws IOException {
        String mimeType = TIKA.detect(name);
        if ((mimeType == null || StringUtils.equals((String)"application/octet-stream", (String)mimeType)) && inputStream != null) {
            mimeType = TIKA.detect(inputStream);
        }
        if (mimeType == null) {
            logger.warn("Unable to resolve mime type for file {}", (Object)name);
        }
        return mimeType;
    }

    private static JCRNodeWrapper ensureDir(String path, JCRSessionWrapper currentUserSession) throws RepositoryException {
        try {
            return currentUserSession.getNode(JCRContentUtils.escapeNodePath((String)path));
        }
        catch (RepositoryException e) {
            if (e instanceof PathNotFoundException || e.getCause() != null && e.getCause() instanceof MalformedPathException) {
                int endIndex = path.lastIndexOf(47);
                if (endIndex == -1) {
                    return null;
                }
                JCRNodeWrapper parentDir = ZipUtils.ensureDir(path.substring(0, endIndex), currentUserSession);
                if (parentDir == null) {
                    return null;
                }
                return parentDir.createCollection(JCRContentUtils.escapeLocalNodeName((String)path.substring(path.lastIndexOf(47) + 1)));
            }
            throw e;
        }
    }
}

