/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.modules.graphql.provider.dxm.workflow;

import graphql.annotations.annotationTypes.GraphQLDescription;
import graphql.annotations.annotationTypes.GraphQLField;
import java.util.List;
import java.util.stream.Collectors;
import org.jahia.modules.graphql.provider.dxm.workflow.GqlTask;
import org.jahia.modules.graphql.provider.dxm.workflow.GqlWorkflow;
import org.jahia.services.content.JCRSessionFactory;
import org.jahia.services.workflow.WorkflowService;

public class GqlWorkflowEvent {
    private WorkflowService workflowService;
    private GqlWorkflow startedWorkflow;
    private GqlWorkflow endedWorkflow;
    private GqlTask createdTask;
    private GqlTask endedTask;

    public GqlWorkflowEvent(WorkflowService workflowService) {
        this.workflowService = workflowService;
    }

    @GraphQLField
    @GraphQLDescription(value="Workflow that has just been started")
    public GqlWorkflow getStartedWorkflow() {
        return this.startedWorkflow;
    }

    public void setStartedWorkflow(GqlWorkflow startedWorkflow) {
        this.startedWorkflow = startedWorkflow;
    }

    @GraphQLField
    @GraphQLDescription(value="Workflow that has just been ended")
    public GqlWorkflow getEndedWorkflow() {
        return this.endedWorkflow;
    }

    public void setEndedWorkflow(GqlWorkflow endedWorkflow) {
        this.endedWorkflow = endedWorkflow;
    }

    @GraphQLField
    @GraphQLDescription(value="Task that has just been created")
    public GqlTask getCreatedTask() {
        return this.createdTask;
    }

    public void setCreatedTask(GqlTask createdTask) {
        this.createdTask = createdTask;
    }

    @GraphQLField
    @GraphQLDescription(value="Task that has just been ended")
    public GqlTask getEndedTask() {
        return this.endedTask;
    }

    public void setEndedTask(GqlTask endedTask) {
        this.endedTask = endedTask;
    }

    @GraphQLField
    @GraphQLDescription(value="Number of tasks for current user")
    public Integer activeWorkflowTaskCountForUser() {
        List tasksForUser = this.workflowService.getTasksForUser(JCRSessionFactory.getInstance().getCurrentUser(), null);
        if (this.endedTask != null) {
            tasksForUser = tasksForUser.stream().filter(workflowTask -> !workflowTask.getId().equals(this.endedTask.getTask().getId())).collect(Collectors.toList());
        }
        return tasksForUser.size();
    }
}

