/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.modules.graphql.provider.dxm;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import org.apache.commons.beanutils.PropertyUtils;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BundleScanner {
    private static Logger logger = LoggerFactory.getLogger(BundleScanner.class);

    public static <T> Collection<Class<? extends T>> getClasses(Object context, Class<? extends Annotation> annotation) {
        ArrayList<Class<? extends T>> classes = new ArrayList<Class<? extends T>>();
        String packageName = context.getClass().getPackage().getName();
        String path = packageName.replace('.', '/');
        BundleScanner.findClasses(path, annotation, classes, context.getClass().getClassLoader());
        return classes;
    }

    private static <T> void findClasses(String path, Class<? extends Annotation> annotation, List<Class<? extends T>> classes, ClassLoader classLoader) {
        try {
            Bundle bundle = (Bundle)PropertyUtils.getProperty((Object)classLoader, (String)"bundle");
            Enumeration items = bundle.getEntryPaths(path);
            if (items != null) {
                while (items.hasMoreElements()) {
                    String subpath = (String)items.nextElement();
                    if (subpath.endsWith(".class")) {
                        if (subpath.contains("$")) continue;
                        try {
                            Class<?> c = Class.forName(subpath.substring(0, subpath.length() - 6).replace('/', '.'), true, classLoader);
                            if (!c.isAnnotationPresent(annotation)) continue;
                            classes.add(c);
                        }
                        catch (ClassNotFoundException | NoClassDefFoundError e) {
                            logger.warn("Cannot load class " + subpath);
                        }
                        continue;
                    }
                    BundleScanner.findClasses(subpath, annotation, classes, classLoader);
                }
            }
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            logger.warn("Cannot scan classes from " + classLoader + " classpath", (Throwable)e);
        }
    }
}

