/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.modules.graphql.provider.dxm.acl.service;

import javax.jcr.RepositoryException;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.decorator.JCRSiteNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JahiaAclEntry {
    private static Logger logger = LoggerFactory.getLogger(JahiaAclEntry.class);
    private final String fromPath;
    private final String sourcePath;
    private String siteKey;
    private final AclEntryType type;
    private final String principalKey;
    private String roleName;
    private String externalPermissionsName = "";

    public JahiaAclEntry(JCRNodeWrapper jcrNode, String principalKey, String[] permission) {
        this.principalKey = principalKey;
        this.sourcePath = jcrNode.getPath();
        this.fromPath = permission[0];
        this.setSiteKey(jcrNode);
        this.type = AclEntryType.valueOf(permission[1]);
        if (this.type == AclEntryType.EXTERNAL) {
            String[] roleNames = permission[2].split("/");
            this.roleName = roleNames[0];
            this.externalPermissionsName = roleNames[1];
        } else {
            this.roleName = permission[2];
        }
    }

    private void setSiteKey(JCRNodeWrapper jcrNode) {
        JCRSiteNode site = null;
        try {
            site = jcrNode.getResolveSite();
        }
        catch (RepositoryException e) {
            logger.debug("unable to fetch site for node {}", (Object)jcrNode.getPath());
        }
        this.siteKey = site != null ? site.getSiteKey() : null;
    }

    public boolean isInherited() {
        return !this.sourcePath.equals(this.fromPath);
    }

    public AclEntryType getType() {
        return this.type;
    }

    public String getFromPath() {
        return this.fromPath;
    }

    public String getSourcePath() {
        return this.sourcePath;
    }

    public String getSiteKey() {
        return this.siteKey;
    }

    public String getPrincipalKey() {
        return this.principalKey;
    }

    public String getRoleName() {
        return this.roleName;
    }

    public String getExternalRoleName() {
        String externalRoleName = this.getRoleName();
        if (this.isExternalType() && !this.externalPermissionsName.isEmpty()) {
            externalRoleName = externalRoleName + "/" + this.externalPermissionsName;
        }
        return externalRoleName;
    }

    public String getExternalPermissionsName() {
        return this.externalPermissionsName;
    }

    public boolean isExternalType() {
        return this.type == AclEntryType.EXTERNAL;
    }

    public boolean isGrantType() {
        return this.type == AclEntryType.GRANT;
    }

    public boolean isDenyType() {
        return this.type == AclEntryType.DENY;
    }

    public static enum AclEntryType {
        GRANT,
        DENY,
        EXTERNAL;

    }
}

