/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.modules.graphql.provider.dxm.admin;

import graphql.annotations.annotationTypes.GraphQLDefaultValue;
import graphql.annotations.annotationTypes.GraphQLDescription;
import graphql.annotations.annotationTypes.GraphQLField;
import graphql.annotations.annotationTypes.GraphQLName;
import graphql.annotations.annotationTypes.GraphQLNonNull;
import java.io.IOException;
import javax.inject.Inject;
import org.apache.commons.lang.StringUtils;
import org.jahia.modules.graphql.provider.dxm.DataFetchingException;
import org.jahia.modules.graphql.provider.dxm.osgi.annotations.GraphQLOsgiService;
import org.jahia.modules.graphql.provider.dxm.osgiconfig.GqlConfigurationMutation;
import org.jahia.modules.graphql.provider.dxm.util.GqlUtils;
import org.jahia.services.modulemanager.spi.Config;
import org.jahia.services.modulemanager.spi.ConfigService;

@GraphQLName(value="JahiaAdminMutation")
@GraphQLDescription(value="Admin mutations")
public class GqlJahiaAdminMutation {
    @Inject
    @GraphQLOsgiService
    private ConfigService configService;

    @GraphQLField
    @GraphQLDescription(value="Mutate an OSGi configuration")
    public GqlConfigurationMutation configuration(@GraphQLName(value="pid") @GraphQLDescription(value="Configuration pid ot factory pid") @GraphQLNonNull String pid, @GraphQLName(value="identifier") @GraphQLDescription(value="If factory pid, configiration identifier (filename suffix)") String identifier, @GraphQLName(value="updateOnly") @GraphQLDescription(value="Do not create new configuration, update existing one") @GraphQLDefaultValue(value=GqlUtils.SupplierFalse.class) Boolean updateOnly) {
        try {
            Config configuration = identifier == null ? this.configService.getConfig(pid) : this.configService.getConfig(pid, identifier);
            if (updateOnly.booleanValue() && StringUtils.isEmpty((String)configuration.getContent())) {
                return null;
            }
            return new GqlConfigurationMutation(configuration);
        }
        catch (IOException e) {
            throw new DataFetchingException(e);
        }
    }
}

