/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.modules.graphql.provider.dxm.cors;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.jahia.modules.graphql.provider.dxm.config.DXGraphQLConfig;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={Filter.class}, property={"pattern=/graphql"}, immediate=true)
public class CorsFilter
implements Filter {
    private static final Logger logger = LoggerFactory.getLogger(CorsFilter.class);
    private static final List<String> ALLOWED_HEADERS = Arrays.asList("authorization", "content-type");
    private DXGraphQLConfig config;

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }

    @Reference
    public void setConfig(DXGraphQLConfig config) {
        this.config = config;
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain chain) throws IOException, ServletException {
        if (servletResponse instanceof HttpServletResponse && servletRequest instanceof HttpServletRequest) {
            HttpServletResponse response = (HttpServletResponse)servletResponse;
            HttpServletRequest request = (HttpServletRequest)servletRequest;
            String origin = request.getHeader("origin");
            if (StringUtils.isNotBlank((String)origin) && this.checkOrigin(origin)) {
                response.setHeader("Access-Control-Allow-Origin", origin);
                if (request.getMethod().equalsIgnoreCase("OPTIONS")) {
                    String[] requestHeaders = StringUtils.split((String)request.getHeader("Access-Control-Request-Headers"), (String)", ");
                    List filteredHeader = Arrays.stream(requestHeaders).map(String::toLowerCase).filter(ALLOWED_HEADERS::contains).collect(Collectors.toList());
                    response.setHeader("Access-Control-Allow-Credentials", "true");
                    response.addHeader("Access-Control-Allow-Headers", StringUtils.join(filteredHeader, (String)","));
                }
            }
        }
        chain.doFilter(servletRequest, servletResponse);
    }

    public boolean checkOrigin(String origin) {
        return this.config.getCorsOrigins().contains(origin);
    }
}

