/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.modules.graphql.provider.dxm.node;

import graphql.annotations.annotationTypes.GraphQLDescription;
import graphql.annotations.annotationTypes.GraphQLField;
import graphql.annotations.annotationTypes.GraphQLName;
import graphql.annotations.annotationTypes.GraphQLNonNull;
import graphql.relay.Edge;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.function.Function;
import java.util.stream.DoubleStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import org.apache.jackrabbit.util.ISO8601;
import org.jahia.modules.graphql.provider.dxm.DataFetchingException;
import org.jahia.modules.graphql.provider.dxm.node.GqlJcrNode;
import org.jahia.modules.graphql.provider.dxm.node.NodeHelper;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRPropertyWrapper;
import pl.touk.throwing.ThrowingSupplier;

@GraphQLName(value="JCRNodeAggregation")
@GraphQLDescription(value="Aggregations on JCR Nodes")
public class GqlJcrNodeAggregation {
    private List<Edge<GqlJcrNode>> edges;

    public GqlJcrNodeAggregation(List<Edge<GqlJcrNode>> edges) {
        this.edges = edges;
    }

    @GraphQLField
    @GraphQLName(value="count")
    @GraphQLDescription(value="Count aggregation")
    public CountAggregation getCount() {
        return new CountAggregation();
    }

    @GraphQLField
    @GraphQLName(value="sum")
    @GraphQLDescription(value="Sum aggregation")
    public StatAggregation getSum() {
        return new StatAggregation(LongStream::sum, DoubleStream::sum);
    }

    @GraphQLField
    @GraphQLName(value="max")
    @GraphQLDescription(value="Max aggregation")
    public StatAggregation getMax() {
        return new StatAggregation(l -> l.max().orElseThrow(() -> new DataFetchingException("No value")), d -> d.max().orElseThrow(() -> new DataFetchingException("No value")));
    }

    @GraphQLField
    @GraphQLName(value="min")
    @GraphQLDescription(value="Min aggregation")
    public StatAggregation getMin() {
        return new StatAggregation(l -> l.min().orElseThrow(() -> new DataFetchingException("No value")), d -> d.min().orElseThrow(() -> new DataFetchingException("No value")));
    }

    @GraphQLField
    @GraphQLName(value="avg")
    @GraphQLDescription(value="Average aggregation")
    public StatAggregation getAvg() {
        return new StatAggregation(l -> (long)l.average().orElseThrow(() -> new DataFetchingException("No value")), d -> d.average().orElseThrow(() -> new DataFetchingException("No value")));
    }

    private Stream<Value> getAllValues(@GraphQLNonNull @GraphQLName(value="name") @GraphQLDescription(value="The name of the JCR property") String name, @GraphQLName(value="language") @GraphQLDescription(value="The language to obtain the property in; must be a valid language code for internationalized properties, does not matter for non-internationalized ones") String language) {
        return this.edges.stream().flatMap(edge -> {
            try {
                JCRNodeWrapper node = NodeHelper.getNodeInLanguage(((GqlJcrNode)edge.getNode()).getNode(), language);
                if (!node.hasProperty(name)) {
                    return null;
                }
                JCRPropertyWrapper property = node.getProperty(name);
                if (property.isMultiple()) {
                    return Arrays.stream(property.getValues());
                }
                return Stream.of(property.getValue());
            }
            catch (RepositoryException e) {
                throw new DataFetchingException(e);
            }
        });
    }

    @GraphQLDescription(value="Simple numeric aggregation on properties values")
    public class StatAggregation {
        private Function<LongStream, Long> longFunction;
        private Function<DoubleStream, Double> doubleFunction;

        public StatAggregation(Function<LongStream, Long> longFunction, Function<DoubleStream, Double> doubleFunction) {
            this.longFunction = longFunction;
            this.doubleFunction = doubleFunction;
        }

        @GraphQLField
        @GraphQLDescription(value="The long representation of a JCR node property")
        public Long longPropertyValue(@GraphQLName(value="name") @GraphQLDescription(value="The name of the JCR property") @GraphQLNonNull String name, @GraphQLName(value="language") @GraphQLDescription(value="The language to obtain the property in; must be a valid language code for internationalized properties, does not matter for non-internationalized ones") String language) {
            return this.longFunction.apply(GqlJcrNodeAggregation.this.getAllValues(name, language).mapToLong(v -> (Long)ThrowingSupplier.unchecked(() -> ((Value)v).getLong()).get()));
        }

        @GraphQLField
        @GraphQLDescription(value="The float representation of a JCR node property")
        public Double floatPropertyValue(@GraphQLName(value="name") @GraphQLDescription(value="The name of the JCR property") @GraphQLNonNull String name, @GraphQLName(value="language") @GraphQLDescription(value="The language to obtain the property in; must be a valid language code for internationalized properties, does not matter for non-internationalized ones") String language) {
            return this.doubleFunction.apply(GqlJcrNodeAggregation.this.getAllValues(name, language).mapToDouble(v -> (Double)ThrowingSupplier.unchecked(() -> ((Value)v).getDouble()).get()));
        }

        @GraphQLField
        @GraphQLDescription(value="The date representation of a JCR node property")
        public String datePropertyValue(@GraphQLName(value="name") @GraphQLDescription(value="The name of the JCR property") @GraphQLNonNull String name, @GraphQLName(value="language") @GraphQLDescription(value="The language to obtain the property in; must be a valid language code for internationalized properties, does not matter for non-internationalized ones") String language) {
            GregorianCalendar c = new GregorianCalendar();
            c.setTime(new Date(this.longPropertyValue(name, language)));
            return ISO8601.format((Calendar)c);
        }
    }

    @GraphQLDescription(value="Simple node count aggregation")
    public class CountAggregation {
        @GraphQLField
        @GraphQLDescription(value="Count all values")
        public Integer values(@GraphQLName(value="name") @GraphQLDescription(value="The name of the JCR property") @GraphQLNonNull String name, @GraphQLName(value="language") @GraphQLDescription(value="The language to obtain the property in; must be a valid language code for internationalized properties, does not matter for non-internationalized ones") String language) {
            return (int)GqlJcrNodeAggregation.this.getAllValues(name, language).count();
        }
    }
}

