/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.modules.graphql.provider.dxm.node;

import graphql.schema.DataFetchingEnvironment;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import org.jahia.modules.graphql.provider.dxm.node.GqlJcrNode;
import org.jahia.modules.graphql.provider.dxm.node.GqlJcrNodeImpl;
import org.jahia.modules.graphql.provider.dxm.node.GqlJcrWrongInputException;
import org.jahia.modules.graphql.provider.dxm.node.SpecializedTypesHandler;
import org.jahia.modules.graphql.provider.dxm.predicate.FieldEvaluator;
import org.jahia.modules.graphql.provider.dxm.predicate.FieldFiltersInput;
import org.jahia.modules.graphql.provider.dxm.predicate.FieldGroupingInput;
import org.jahia.modules.graphql.provider.dxm.predicate.FieldSorterInput;
import org.jahia.modules.graphql.provider.dxm.predicate.FilterHelper;
import org.jahia.modules.graphql.provider.dxm.predicate.GroupingHelper;
import org.jahia.modules.graphql.provider.dxm.predicate.MulticriteriaEvaluation;
import org.jahia.modules.graphql.provider.dxm.predicate.PredicateHelper;
import org.jahia.modules.graphql.provider.dxm.predicate.SorterHelper;
import org.jahia.modules.graphql.provider.dxm.relay.DXPaginatedData;
import org.jahia.modules.graphql.provider.dxm.relay.PaginationHelper;
import org.jahia.modules.graphql.provider.dxm.security.PermissionHelper;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRPropertyWrapper;
import org.jahia.services.content.JCRSessionFactory;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.JCRStoreService;
import org.jahia.services.content.JCRValueWrapper;
import org.jahia.services.content.decorator.JCRSiteNode;
import org.jahia.services.visibility.VisibilityService;
import org.jahia.utils.LanguageCodeConverters;
import pl.touk.throwing.ThrowingFunction;
import pl.touk.throwing.ThrowingPredicate;

public class NodeHelper {
    private static HashMap<GqlJcrNode.PropertyEvaluation, PropertyEvaluationAlgorithm> ALGORITHM_BY_EVALUATION = new HashMap();

    public static Predicate<JCRNodeWrapper> getPropertiesPredicate(GqlJcrNode.NodePropertiesInput propertiesFilter) {
        Predicate<Object> propertiesPredicate;
        if (propertiesFilter == null) {
            propertiesPredicate = PredicateHelper.truePredicate();
        } else {
            LinkedList propertyPredicates = new LinkedList();
            for (GqlJcrNode.NodePropertyInput propertyFilter : propertiesFilter.getPropertyFilters()) {
                PropertyEvaluationAlgorithm evaluationAlgorithm;
                GqlJcrNode.PropertyEvaluation propertyEvaluation = propertyFilter.getPropertyEvaluation();
                if (propertyEvaluation == null) {
                    propertyEvaluation = GqlJcrNode.PropertyEvaluation.EQUAL;
                }
                if ((evaluationAlgorithm = ALGORITHM_BY_EVALUATION.get((Object)propertyEvaluation)) == null) {
                    throw new IllegalArgumentException("Unknown property evaluation: " + (Object)((Object)propertyEvaluation));
                }
                propertyPredicates.add(node -> evaluationAlgorithm.evaluate((JCRNodeWrapper)node, propertyFilter.getLanguage(), propertyFilter.getPropertyName(), propertyFilter.getPropertyValue()));
            }
            propertiesPredicate = PredicateHelper.getCombinedPredicate(propertyPredicates, propertiesFilter.getMulticriteriaEvaluation(), MulticriteriaEvaluation.ALL);
        }
        return propertiesPredicate;
    }

    public static Predicate<JCRNodeWrapper> getTypesPredicate(GqlJcrNode.NodeTypesInput typesFilter) {
        Predicate<Object> typesPredicate;
        if (typesFilter == null) {
            typesPredicate = PredicateHelper.truePredicate();
        } else {
            LinkedList typePredicates = new LinkedList();
            for (String typeFilter : typesFilter.getTypes()) {
                typePredicates.add(ThrowingPredicate.unchecked(node -> node.isNodeType(typeFilter)));
            }
            typesPredicate = PredicateHelper.getCombinedPredicate(typePredicates, typesFilter.getMulticriteriaEvaluation(), MulticriteriaEvaluation.ANY);
        }
        return typesPredicate;
    }

    private static boolean hasProperty(JCRNodeWrapper node, String language, String propertyName) {
        try {
            node = NodeHelper.getNodeInLanguage(node, language);
            return node.hasProperty(propertyName);
        }
        catch (RepositoryException e) {
            throw new RuntimeException(e);
        }
    }

    private static boolean hasPropertyValue(JCRNodeWrapper node, String language, String propertyName, String propertyValue) {
        try {
            node = NodeHelper.getNodeInLanguage(node, language);
            if (!node.hasProperty(propertyName)) {
                return false;
            }
            JCRPropertyWrapper property = node.getProperty(propertyName);
            if (!property.isMultiple()) {
                return property.getString().equals(propertyValue);
            }
            for (JCRValueWrapper value : property.getValues()) {
                if (!value.getString().equals(propertyValue)) continue;
                return true;
            }
            return false;
        }
        catch (RepositoryException e) {
            throw new RuntimeException(e);
        }
    }

    public static JCRNodeWrapper getNodeInLanguage(JCRNodeWrapper node, String language) throws RepositoryException {
        return NodeHelper.getNodeInLanguage(node, language, false);
    }

    public static JCRNodeWrapper getNodeInLanguage(JCRNodeWrapper node, String language, boolean useFallbackLanguage) throws RepositoryException {
        String workspace = node.getSession().getWorkspace().getName();
        if (language == null) {
            if (node.getLanguage() != null) {
                JCRSessionWrapper session = JCRSessionFactory.getInstance().getCurrentUserSession(workspace, Locale.forLanguageTag(node.getLanguage()));
                return session.getNodeByIdentifier(node.getIdentifier());
            }
            return node;
        }
        Locale locale = LanguageCodeConverters.languageCodeToLocale((String)language);
        JCRSessionWrapper session = JCRSessionFactory.getInstance().getCurrentUserSession(workspace, locale, useFallbackLanguage ? NodeHelper.getFallbackLanguage(node) : null);
        return session.getNodeByIdentifier(node.getIdentifier());
    }

    private static Locale getFallbackLanguage(JCRNodeWrapper node) throws RepositoryException {
        JCRSiteNode siteNode = node.getResolveSite();
        if (siteNode != null && siteNode.isMixLanguagesActive()) {
            return LanguageCodeConverters.languageCodeToLocale((String)siteNode.getDefaultLanguage());
        }
        return null;
    }

    public static boolean checkNodeValidity(JCRNodeWrapper node) throws RepositoryException {
        if ("live".equals(node.getSession().getWorkspace().getName()) && !JCRStoreService.getInstance().getNoValidityCheckTypes().contains(node.getPrimaryNodeTypeName())) {
            return (!node.hasProperty("j:published") || node.getProperty("j:published").getBoolean()) && VisibilityService.getInstance().matchesConditions(node);
        }
        return true;
    }

    static void collectDescendants(JCRNodeWrapper node, Predicate<JCRNodeWrapper> predicate, Predicate<JCRNodeWrapper> recursionPredicate, Consumer<JCRNodeWrapper> consumer) throws RepositoryException {
        for (JCRNodeWrapper child : node.getNodes()) {
            if (predicate.test(child)) {
                consumer.accept(child);
            }
            if (!recursionPredicate.test(child)) continue;
            NodeHelper.collectDescendants(child, predicate, recursionPredicate, consumer);
        }
    }

    static Predicate<JCRNodeWrapper> getNodesPredicate(Collection<String> names, GqlJcrNode.NodeTypesInput typesFilter, GqlJcrNode.NodePropertiesInput propertiesFilter, DataFetchingEnvironment environment) {
        Predicate<Object> namesPredicate = names == null ? PredicateHelper.truePredicate() : node -> names.contains(node.getName());
        Predicate<JCRNodeWrapper> typesPredicate = NodeHelper.getTypesPredicate(typesFilter);
        Predicate<JCRNodeWrapper> propertiesPredicate = NodeHelper.getPropertiesPredicate(propertiesFilter);
        Predicate<Object> permissionPredicate = environment == null ? PredicateHelper.truePredicate() : node -> PermissionHelper.hasPermission(node, environment);
        Predicate<JCRNodeWrapper> result = PredicateHelper.allPredicates(Arrays.asList(GqlJcrNodeImpl.DEFAULT_CHILDREN_PREDICATE, namesPredicate, typesPredicate, propertiesPredicate, permissionPredicate));
        return result;
    }

    public static DXPaginatedData<GqlJcrNode> getPaginatedNodesList(NodeIterator it, Collection<String> names, GqlJcrNode.NodeTypesInput typesFilter, GqlJcrNode.NodePropertiesInput propertiesFilter, FieldFiltersInput fieldFilter, DataFetchingEnvironment environment, FieldSorterInput fieldSorterInput, FieldGroupingInput fieldGroupingInput) {
        Stream<Object> stream = StreamSupport.stream(Spliterators.spliteratorUnknownSize(it, 16), false).filter(node -> PermissionHelper.hasPermission(node, environment)).filter(NodeHelper.getNodesPredicate(names, typesFilter, propertiesFilter, environment)).filter(ThrowingPredicate.unchecked(NodeHelper::checkNodeValidity)).map(ThrowingFunction.unchecked(SpecializedTypesHandler::getNode)).filter(FilterHelper.getFieldPredicate(fieldFilter, FieldEvaluator.forConnection(environment)));
        if (fieldSorterInput != null) {
            stream = stream.sorted(SorterHelper.getFieldComparator(fieldSorterInput, FieldEvaluator.forConnection(environment)));
        }
        if (fieldGroupingInput != null) {
            stream = GroupingHelper.group(stream, fieldGroupingInput, FieldEvaluator.forConnection(environment));
        }
        PaginationHelper.Arguments arguments = PaginationHelper.parseArguments(environment);
        return PaginationHelper.paginate(stream, n -> PaginationHelper.encodeCursor(n.getUuid()), arguments);
    }

    static {
        ALGORITHM_BY_EVALUATION.put(GqlJcrNode.PropertyEvaluation.PRESENT, new PropertyEvaluationAlgorithm(){

            @Override
            public boolean evaluate(JCRNodeWrapper node, String language, String propertyName, String propertyValue) {
                return NodeHelper.hasProperty(node, language, propertyName);
            }
        });
        ALGORITHM_BY_EVALUATION.put(GqlJcrNode.PropertyEvaluation.ABSENT, new PropertyEvaluationAlgorithm(){

            @Override
            public boolean evaluate(JCRNodeWrapper node, String language, String propertyName, String propertyValue) {
                return !NodeHelper.hasProperty(node, language, propertyName);
            }
        });
        ALGORITHM_BY_EVALUATION.put(GqlJcrNode.PropertyEvaluation.EQUAL, new PropertyEvaluationAlgorithm(){

            @Override
            public boolean evaluate(JCRNodeWrapper node, String language, String propertyName, String propertyValue) {
                if (propertyValue == null) {
                    throw new GqlJcrWrongInputException("Property value is required for " + (Object)((Object)GqlJcrNode.PropertyEvaluation.EQUAL) + " evaluation");
                }
                return NodeHelper.hasPropertyValue(node, language, propertyName, propertyValue);
            }
        });
        ALGORITHM_BY_EVALUATION.put(GqlJcrNode.PropertyEvaluation.DIFFERENT, new PropertyEvaluationAlgorithm(){

            @Override
            public boolean evaluate(JCRNodeWrapper node, String language, String propertyName, String propertyValue) {
                if (propertyValue == null) {
                    throw new GqlJcrWrongInputException("Property value is required for " + (Object)((Object)GqlJcrNode.PropertyEvaluation.DIFFERENT) + " evaluation");
                }
                return !NodeHelper.hasPropertyValue(node, language, propertyName, propertyValue);
            }
        });
    }

    private static interface PropertyEvaluationAlgorithm {
        public boolean evaluate(JCRNodeWrapper var1, String var2, String var3, String var4);
    }
}

