/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.modules.graphql.provider.dxm.node;

import graphql.annotations.annotationTypes.GraphQLDescription;
import graphql.annotations.annotationTypes.GraphQLField;
import graphql.annotations.annotationTypes.GraphQLName;
import graphql.annotations.annotationTypes.GraphQLNonNull;
import graphql.annotations.annotationTypes.GraphQLTypeExtension;
import org.jahia.modules.graphql.provider.dxm.DXGraphQLProvider;
import org.jahia.modules.graphql.provider.dxm.node.GqlJcrQuery;

@GraphQLTypeExtension(value=DXGraphQLProvider.Query.class)
@GraphQLDescription(value="A query extension that adds a possibility to fetch nodes by their UUIDs, paths, or via an SQL2/Xpath query")
public class NodeQueryExtensions {
    @GraphQLField
    @GraphQLName(value="jcr")
    @GraphQLNonNull
    @GraphQLDescription(value="JCR Queries")
    public static GqlJcrQuery getJcr(@GraphQLName(value="workspace") @GraphQLDescription(value="The name of the workspace to fetch the node from; either EDIT, LIVE, or null to use EDIT by default") Workspace workspace) {
        return new GqlJcrQuery(workspace != null ? workspace : Workspace.EDIT);
    }

    @GraphQLDescription(value="JCR workspace to use for the operations")
    public static enum Workspace {
        EDIT("default"),
        LIVE("live");

        private String workspace;

        private Workspace(String workspace) {
            this.workspace = workspace;
        }

        public String getValue() {
            return this.workspace;
        }
    }
}

