/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.modules.graphql.provider.dxm.nodetype;

import graphql.annotations.annotationTypes.GraphQLDescription;
import graphql.annotations.annotationTypes.GraphQLField;
import graphql.annotations.annotationTypes.GraphQLName;
import graphql.annotations.annotationTypes.GraphQLNonNull;
import graphql.annotations.connection.GraphQLConnection;
import graphql.annotations.connection.PaginatedData;
import graphql.schema.DataFetchingEnvironment;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.jcr.RepositoryException;
import org.jahia.modules.graphql.provider.dxm.node.GqlJcrNode;
import org.jahia.modules.graphql.provider.dxm.nodetype.GqlJcrItemDefinition;
import org.jahia.modules.graphql.provider.dxm.nodetype.GqlJcrNodeDefinition;
import org.jahia.modules.graphql.provider.dxm.nodetype.GqlJcrPropertyDefinition;
import org.jahia.modules.graphql.provider.dxm.nodetype.NodeTypeHelper;
import org.jahia.modules.graphql.provider.dxm.predicate.FieldEvaluator;
import org.jahia.modules.graphql.provider.dxm.predicate.FieldFiltersInput;
import org.jahia.modules.graphql.provider.dxm.predicate.FilterHelper;
import org.jahia.modules.graphql.provider.dxm.relay.DXPaginatedDataConnectionFetcher;
import org.jahia.modules.graphql.provider.dxm.relay.PaginationHelper;
import org.jahia.services.content.JCRContentUtils;
import org.jahia.services.content.nodetypes.ExtendedNodeDefinition;
import org.jahia.services.content.nodetypes.ExtendedNodeType;
import org.jahia.services.content.nodetypes.ExtendedPropertyDefinition;
import org.jahia.utils.LanguageCodeConverters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@GraphQLName(value="JCRNodeType")
@GraphQLDescription(value="GraphQL representation of a JCR node type")
public class GqlJcrNodeType {
    public static final Logger logger = LoggerFactory.getLogger(GqlJcrNodeType.class);
    private ExtendedNodeType nodeType;

    public GqlJcrNodeType(ExtendedNodeType nodeType) {
        this.nodeType = nodeType;
    }

    public ExtendedNodeType getNodeType() {
        return this.nodeType;
    }

    @GraphQLField
    @GraphQLName(value="name")
    @GraphQLDescription(value="Node type name")
    public String getName() {
        return this.nodeType.getName();
    }

    @GraphQLField
    @GraphQLName(value="displayName")
    @GraphQLDescription(value="Node type displayable name")
    public String getDisplayName(@GraphQLName(value="language") @GraphQLDescription(value="Language") @GraphQLNonNull String language) {
        return this.nodeType.getLabel(LanguageCodeConverters.languageCodeToLocale((String)language));
    }

    @GraphQLField
    @GraphQLName(value="icon")
    @GraphQLDescription(value="Node type icon")
    public String getIcon() {
        try {
            return this.getIcon(this.nodeType);
        }
        catch (RepositoryException e) {
            throw new RuntimeException(e);
        }
    }

    @GraphQLField
    @GraphQLName(value="systemId")
    @GraphQLDescription(value="System ID of the node type, corresponding to the name of the module declaring it.")
    public String getSystemId() {
        return this.nodeType.getSystemId();
    }

    @GraphQLField
    @GraphQLName(value="mixin")
    @GraphQLDescription(value="Returns true if this is a mixin type; returns false otherwise.")
    public boolean isMixin() {
        return this.nodeType.isMixin();
    }

    @GraphQLField
    @GraphQLName(value="abstract")
    @GraphQLDescription(value="Returns true if this is an abstract node type; returns false otherwise.")
    public boolean isAbstract() {
        return this.nodeType.isAbstract();
    }

    @GraphQLField
    @GraphQLName(value="hasOrderableChildNodes")
    @GraphQLDescription(value="Returns true if nodes of this type must support orderable child nodes; returns false otherwise.")
    public boolean isHasOrderableChildNodes() {
        return this.nodeType.hasOrderableChildNodes();
    }

    @GraphQLField
    @GraphQLName(value="queryable")
    @GraphQLDescription(value="Returns true if the node type is queryable.")
    public boolean isQueryable() {
        return this.nodeType.isQueryable();
    }

    @GraphQLField
    @GraphQLName(value="isNodeType")
    @GraphQLDescription(value="Reports if the current node type matches the nodetype(s) passed in parameter")
    @GraphQLNonNull
    public boolean isNodeType(@GraphQLName(value="type") @GraphQLDescription(value="Node type name") @GraphQLNonNull GqlJcrNode.NodeTypesInput input) {
        return NodeTypeHelper.getTypesPredicate(input).test(this.nodeType);
    }

    @GraphQLField
    @GraphQLName(value="primaryItem")
    @GraphQLDescription(value="Returns the name of the primary item (one of the child items of the nodes of this node type). If this node has no primary item, then this method null.")
    public GqlJcrItemDefinition getPrimaryItem() {
        String primaryItemName = this.nodeType.getPrimaryItemName();
        if (primaryItemName != null) {
            if (this.nodeType.getChildNodeDefinitionsAsMap().containsKey(primaryItemName)) {
                return new GqlJcrNodeDefinition((ExtendedNodeDefinition)this.nodeType.getChildNodeDefinitionsAsMap().get(primaryItemName));
            }
            if (this.nodeType.getPropertyDefinitionsAsMap().containsKey(primaryItemName)) {
                return new GqlJcrPropertyDefinition((ExtendedPropertyDefinition)this.nodeType.getPropertyDefinitionsAsMap().get(primaryItemName));
            }
        }
        return null;
    }

    @GraphQLField
    @GraphQLName(value="properties")
    @GraphQLDescription(value="Returns an array containing the property definitions of this node type.")
    public List<GqlJcrPropertyDefinition> getProperties(@GraphQLName(value="fieldFilter") @GraphQLDescription(value="Filter by graphQL fields values") FieldFiltersInput fieldFilter, DataFetchingEnvironment environment) {
        return Arrays.stream(this.nodeType.getPropertyDefinitions()).map(GqlJcrPropertyDefinition::new).filter(FilterHelper.getFieldPredicate(fieldFilter, FieldEvaluator.forList(environment))).collect(Collectors.toList());
    }

    @GraphQLField
    @GraphQLName(value="nodes")
    @GraphQLDescription(value="Returns an array containing the child node definitions of this node type.")
    public List<GqlJcrNodeDefinition> getNodes(@GraphQLName(value="fieldFilter") @GraphQLDescription(value="Filter by graphQL fields values") FieldFiltersInput fieldFilter, DataFetchingEnvironment environment) {
        return Arrays.stream(this.nodeType.getChildNodeDefinitions()).map(GqlJcrNodeDefinition::new).filter(FilterHelper.getFieldPredicate(fieldFilter, FieldEvaluator.forList(environment))).collect(Collectors.toList());
    }

    @GraphQLField
    @GraphQLName(value="subTypes")
    @GraphQLConnection(connectionFetcher=DXPaginatedDataConnectionFetcher.class)
    @GraphQLDescription(value="Returns all subtypes of this node type in the node type inheritance hierarchy.")
    public PaginatedData<GqlJcrNodeType> getSubtypes(DataFetchingEnvironment environment) {
        PaginationHelper.Arguments arguments = PaginationHelper.parseArguments(environment);
        Stream<GqlJcrNodeType> subTypes = this.nodeType.getSubtypesAsList().stream().map(GqlJcrNodeType::new);
        return PaginationHelper.paginate(subTypes, t -> PaginationHelper.encodeCursor(t.getName()), arguments);
    }

    @GraphQLField
    @GraphQLName(value="supertypes")
    @GraphQLDescription(value="Returns all supertypes of this node type in the node type inheritance hierarchy.")
    public List<GqlJcrNodeType> getSupertypes(@GraphQLName(value="fieldFilter") @GraphQLDescription(value="Filter by graphQL fields values") FieldFiltersInput fieldFilter, DataFetchingEnvironment environment) {
        return this.nodeType.getSupertypeSet().stream().map(GqlJcrNodeType::new).filter(FilterHelper.getFieldPredicate(fieldFilter, FieldEvaluator.forList(environment))).collect(Collectors.toList());
    }

    private String getIcon(ExtendedNodeType type) throws RepositoryException {
        return JCRContentUtils.getIconWithContext((ExtendedNodeType)type);
    }
}

