/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.modules.graphql.provider.dxm.osgi;

import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.apache.commons.lang3.reflect.MethodUtils;
import org.jahia.modules.graphql.provider.dxm.osgi.annotations.GraphQLOsgiService;
import org.jahia.osgi.BundleUtils;
import pl.touk.throwing.ThrowingFunction;

public class OSGIServiceInjectorDataFetcher<T>
implements DataFetcher<T> {
    private final DataFetcher<T> originalDataFetcher;

    public OSGIServiceInjectorDataFetcher(DataFetcher<T> originalDataFetcher) {
        this.originalDataFetcher = originalDataFetcher;
    }

    public T get(DataFetchingEnvironment dataFetchingEnvironment) throws Exception {
        Object data = this.originalDataFetcher.get(dataFetchingEnvironment);
        if (data instanceof CompletableFuture) {
            return (T)((CompletableFuture)data).thenApply(ThrowingFunction.unchecked(this::inject));
        }
        return (T)this.inject(data);
    }

    private T inject(T data) throws IllegalAccessException, InvocationTargetException {
        if (data instanceof Collection) {
            for (Object item : (Collection)data) {
                OSGIServiceInjectorDataFetcher.handleMethodInjection(item);
            }
        } else if (data != null) {
            OSGIServiceInjectorDataFetcher.handleMethodInjection(data);
        }
        return data;
    }

    public static void handleMethodInjection(Object data) throws IllegalAccessException, InvocationTargetException {
        for (Method method : MethodUtils.getMethodsListWithAnnotation(data.getClass(), Inject.class, (boolean)true, (boolean)true)) {
            OSGIServiceInjectorDataFetcher.handleMethodInjection(data, method);
        }
        for (Field field : FieldUtils.getFieldsListWithAnnotation(data.getClass(), Inject.class)) {
            OSGIServiceInjectorDataFetcher.handleFieldInjection(data, field);
        }
    }

    private static void handleMethodInjection(Object data, Method method) throws IllegalAccessException, InvocationTargetException {
        if (method.isAnnotationPresent(GraphQLOsgiService.class) && method.getParameterTypes().length > 0) {
            String filter;
            GraphQLOsgiService annotation = method.getAnnotation(GraphQLOsgiService.class);
            Class<?> klass = annotation.service().equals(Object.class) ? method.getParameterTypes()[0] : annotation.service();
            String string = filter = StringUtils.isNotEmpty((CharSequence)annotation.filter()) ? annotation.filter() : null;
            if (!method.isAccessible()) {
                method.setAccessible(true);
            }
            method.invoke(data, BundleUtils.getOsgiService(klass, (String)filter));
        }
    }

    private static void handleFieldInjection(Object data, Field field) throws IllegalAccessException {
        if (field.isAnnotationPresent(GraphQLOsgiService.class)) {
            String filter;
            GraphQLOsgiService annotation = field.getAnnotation(GraphQLOsgiService.class);
            Class<?> klass = annotation.service().equals(Object.class) ? field.getType() : annotation.service();
            String string = filter = StringUtils.isNotEmpty((CharSequence)annotation.filter()) ? annotation.filter() : null;
            if (!field.isAccessible()) {
                field.setAccessible(true);
            }
            field.set(data, BundleUtils.getOsgiService(klass, (String)filter));
        }
    }
}

