/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.modules.graphql.provider.dxm.osgiconfig;

import graphql.annotations.annotationTypes.GraphQLDescription;
import graphql.annotations.annotationTypes.GraphQLField;
import graphql.annotations.annotationTypes.GraphQLName;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.jahia.modules.graphql.provider.dxm.osgiconfig.GqlValueQuery;
import org.jahia.services.modulemanager.util.PropertiesList;

@GraphQLName(value="ConfigurationItemsListQuery")
@GraphQLDescription(value="Query for configuration list of values")
public class GqlListQuery {
    PropertiesList propertiesList;

    public GqlListQuery(PropertiesList propertiesList) {
        this.propertiesList = propertiesList;
    }

    @GraphQLField
    @GraphQLDescription(value="Adds a new structured object to the list")
    public int getSize() {
        return this.propertiesList.getSize();
    }

    @GraphQLField
    @GraphQLDescription(value="Get sub structured object values")
    public List<GqlValueQuery> getObjects() {
        return IntStream.range(0, this.propertiesList.getSize()).boxed().map(arg_0 -> ((PropertiesList)this.propertiesList).getValues(arg_0)).map(GqlValueQuery::new).collect(Collectors.toList());
    }

    @GraphQLField
    @GraphQLDescription(value="Get sub lists of items")
    public List<GqlListQuery> getLists() {
        return IntStream.range(0, this.propertiesList.getSize()).boxed().map(arg_0 -> ((PropertiesList)this.propertiesList).getList(arg_0)).map(GqlListQuery::new).collect(Collectors.toList());
    }

    @GraphQLField
    @GraphQLDescription(value="Get property values")
    public List<String> getValues() {
        return IntStream.range(0, this.propertiesList.getSize()).boxed().map(arg_0 -> ((PropertiesList)this.propertiesList).getProperty(arg_0)).filter(Objects::nonNull).collect(Collectors.toList());
    }
}

