/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.modules.graphql.provider.dxm.predicate;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import graphql.TypeResolutionEnvironment;
import graphql.execution.ExecutionStepInfo;
import graphql.execution.FieldCollector;
import graphql.execution.FieldCollectorParameters;
import graphql.execution.MergedField;
import graphql.execution.MergedSelectionSet;
import graphql.execution.ValuesResolver;
import graphql.language.Field;
import graphql.language.FragmentDefinition;
import graphql.language.SelectionSet;
import graphql.schema.DataFetchingEnvironment;
import graphql.schema.DataFetchingEnvironmentImpl;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLFieldsContainer;
import graphql.schema.GraphQLInterfaceType;
import graphql.schema.GraphQLList;
import graphql.schema.GraphQLNonNull;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLType;
import graphql.schema.TypeResolver;
import java.lang.reflect.InvocationTargetException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.jahia.modules.graphql.provider.dxm.osgi.OSGIServiceInjectorDataFetcher;
import org.jahia.modules.graphql.provider.dxm.util.ContextUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FieldEvaluator {
    private static final Logger logger = LoggerFactory.getLogger(FieldEvaluator.class);
    private GraphQLType type;
    private FieldFinder fieldFinder;
    private Map<String, Object> variables;
    private DataFetchingEnvironment environment;
    private static final String FIELD_NAME_SEPARATOR = ".";
    private static FieldCollector fieldCollector = new FieldCollector();

    private FieldEvaluator(GraphQLType type, FieldFinder fieldFinder, Map<String, Object> variables, DataFetchingEnvironment environment) {
        this.type = type;
        this.fieldFinder = fieldFinder;
        this.variables = variables;
        this.environment = environment;
    }

    public static FieldEvaluator forList(DataFetchingEnvironment environment) {
        GraphQLOutputType fieldType = environment.getFieldType();
        if (fieldType instanceof GraphQLNonNull) {
            fieldType = (GraphQLOutputType)((GraphQLNonNull)fieldType).getWrappedType();
        }
        GraphQLList list = (GraphQLList)fieldType;
        GraphQLType type = list.getWrappedType();
        FieldFinder fieldFinder = (objectType, name) -> {
            if (environment.getSelectionSet() != null) {
                return FieldEvaluator.getField(environment.getSelectionSet().get(), name);
            }
            return null;
        };
        return new FieldEvaluator(type, fieldFinder, FieldEvaluator.getVariables(environment), environment);
    }

    public static FieldEvaluator forConnection(DataFetchingEnvironment environment) {
        Map<String, Object> variables = FieldEvaluator.getVariables(environment);
        GraphQLOutputType fieldType = environment.getFieldType();
        if (fieldType instanceof GraphQLNonNull) {
            fieldType = (GraphQLOutputType)((GraphQLNonNull)fieldType).getWrappedType();
        }
        GraphQLObjectType outputType = (GraphQLObjectType)fieldType;
        GraphQLList list = (GraphQLList)outputType.getFieldDefinition("nodes").getType();
        GraphQLType type = list.getWrappedType();
        FieldFinder fieldFinder = (objectType, name) -> {
            FieldCollectorParameters parameters = FieldCollectorParameters.newParameters().objectType(objectType).variables(variables).fragments(FieldEvaluator.getFragmentDefinitions(environment)).schema(environment.getGraphQLSchema()).build();
            Map fields = null;
            if (environment.getSelectionSet() != null) {
                MergedField edgeFields;
                MergedSelectionSet merged = environment.getSelectionSet().get();
                fields = merged.getSubFields();
                if (fields.containsKey("nodes")) {
                    MergedField nodeFields = (MergedField)fields.get("nodes");
                    return FieldEvaluator.getField(fieldCollector.collectFields(parameters, nodeFields), name);
                }
                if (fields.containsKey("edges") && (fields = fieldCollector.collectFields(parameters, edgeFields = (MergedField)fields.get("edges")).getSubFields()).containsKey("node")) {
                    return FieldEvaluator.getField(fieldCollector.collectFields(parameters, (MergedField)fields.get("node")), name);
                }
            }
            return null;
        };
        return new FieldEvaluator(type, fieldFinder, variables, environment);
    }

    private static Map<String, Object> getVariables(DataFetchingEnvironment environment) {
        HttpServletRequest request = ContextUtil.getHttpServletRequest(environment.getContext());
        return request != null ? (Map)request.getAttribute("graphQLVariables") : new LinkedHashMap();
    }

    private static Map<String, FragmentDefinition> getFragmentDefinitions(DataFetchingEnvironment environment) {
        HttpServletRequest request = ContextUtil.getHttpServletRequest(environment.getContext());
        return request != null ? (Map)request.getAttribute("fragmentsByName") : new LinkedHashMap();
    }

    private static Field getField(MergedSelectionSet mergedSet, String name) {
        Map fields = mergedSet.getSubFields();
        if (fields != null && fields.containsKey(name)) {
            return ((MergedField)fields.get(name)).getSingleField();
        }
        return null;
    }

    private GraphQLObjectType getObjectType(Object object) {
        if (this.type instanceof GraphQLObjectType) {
            return (GraphQLObjectType)this.type;
        }
        if (this.type instanceof GraphQLInterfaceType) {
            TypeResolver typeResolver = this.environment.getGraphQLSchema().getCodeRegistry().getTypeResolver((GraphQLInterfaceType)this.type);
            return typeResolver.getType(new TypeResolutionEnvironment(object, null, null, null, null, null));
        }
        return null;
    }

    public Object getFieldValue(Object source, String fieldName) {
        GraphQLFieldDefinition fieldDefinition;
        GraphQLObjectType objectType;
        if (source == null) {
            return null;
        }
        List fields = Splitter.on((String)FIELD_NAME_SEPARATOR).splitToList((CharSequence)fieldName);
        String nextField = null;
        if (fields.size() > 1) {
            fieldName = (String)fields.get(0);
            nextField = Joiner.on((String)FIELD_NAME_SEPARATOR).join(fields.subList(1, fields.size()));
        }
        if ((objectType = this.getObjectType(source)) == null) {
            return null;
        }
        try {
            OSGIServiceInjectorDataFetcher.handleMethodInjection(source);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            logger.warn("Cannot inject fields ", (Throwable)e);
        }
        DataFetchingEnvironmentImpl.Builder fieldEnvBuilder = DataFetchingEnvironmentImpl.newDataFetchingEnvironment().source(source).parentType((GraphQLType)objectType).context(this.environment.getContext()).root(this.environment.getRoot()).executionId(this.environment.getExecutionId()).fragmentsByName(this.environment.getFragmentsByName()).graphQLSchema(this.environment.getGraphQLSchema()).executionStepInfo(this.environment.getExecutionStepInfo());
        Field field = this.fieldFinder.find(objectType, fieldName);
        if (field != null) {
            fieldDefinition = objectType.getFieldDefinition(field.getName());
            if (fieldDefinition != null) {
                ValuesResolver valuesResolver = new ValuesResolver();
                Map argumentValues = valuesResolver.getArgumentValues(fieldDefinition.getArguments(), field.getArguments(), this.variables);
                fieldEnvBuilder.arguments(argumentValues);
            }
        } else {
            fieldDefinition = objectType.getFieldDefinition(fieldName);
        }
        if (fieldDefinition == null) {
            return null;
        }
        fieldEnvBuilder.fieldDefinition(fieldDefinition);
        fieldEnvBuilder.fieldType(fieldDefinition.getType());
        fieldEnvBuilder.executionStepInfo(ExecutionStepInfo.newExecutionStepInfo().fieldDefinition(fieldDefinition).type(fieldDefinition.getType()).build());
        Object value = null;
        try {
            DataFetchingEnvironment fieldEnv = fieldEnvBuilder.build();
            value = this.environment.getGraphQLSchema().getCodeRegistry().getDataFetcher((GraphQLFieldsContainer)objectType, fieldDefinition).get(fieldEnv);
        }
        catch (Exception e) {
            value = e.getMessage();
        }
        if (nextField != null && value != null) {
            return this.forSubField(fieldDefinition.getType(), field != null ? field.getSelectionSet() : null).getFieldValue(value, nextField);
        }
        return value;
    }

    private FieldEvaluator forSubField(GraphQLOutputType fieldType, SelectionSet selectionSet) {
        if (fieldType instanceof GraphQLNonNull) {
            fieldType = (GraphQLOutputType)((GraphQLNonNull)fieldType).getWrappedType();
        }
        FieldFinder fieldFinder = (objectType, name) -> {
            if (selectionSet != null) {
                FieldCollectorParameters parameters = FieldCollectorParameters.newParameters().objectType(objectType).variables(FieldEvaluator.getVariables(this.environment)).fragments(FieldEvaluator.getFragmentDefinitions(this.environment)).schema(this.environment.getGraphQLSchema()).build();
                return FieldEvaluator.getField(fieldCollector.collectFields(parameters, selectionSet), name);
            }
            return null;
        };
        return new FieldEvaluator((GraphQLType)fieldType, fieldFinder, FieldEvaluator.getVariables(this.environment), this.environment);
    }

    @FunctionalInterface
    static interface FieldFinder {
        public Field find(GraphQLObjectType var1, String var2);
    }
}

