/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.modules.graphql.provider.dxm.predicate;

import graphql.relay.Connection;
import graphql.schema.DataFetchingEnvironment;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.jahia.modules.graphql.provider.dxm.predicate.FieldEvaluator;
import org.jahia.modules.graphql.provider.dxm.predicate.FieldFilterInput;
import org.jahia.modules.graphql.provider.dxm.predicate.FieldFiltersInput;
import org.jahia.modules.graphql.provider.dxm.predicate.MulticriteriaEvaluation;
import org.jahia.modules.graphql.provider.dxm.predicate.PredicateHelper;

public class FilterHelper {
    private static HashMap<FieldEvaluation, FieldEvaluationAlgorithm> ALGORITHM_BY_EVALUATION = new HashMap();

    public static Predicate<Object> getFieldPredicate(FieldFiltersInput filters, FieldEvaluator environment) {
        Predicate<Object> fieldPredicate;
        if (filters == null) {
            fieldPredicate = PredicateHelper.truePredicate();
        } else {
            LinkedList predicates = new LinkedList();
            for (FieldFilterInput filter : filters.getFilters()) {
                predicates.add(FilterHelper.getFieldPredicate(filter, environment));
            }
            fieldPredicate = PredicateHelper.getCombinedPredicate(predicates, filters.getMulticriteriaEvaluation(), MulticriteriaEvaluation.ALL);
        }
        return fieldPredicate;
    }

    private static Predicate<Object> getFieldPredicate(FieldFilterInput filter, FieldEvaluator environment) {
        FieldFiltersInput subFilter = filter.getFieldFilter();
        if (subFilter == null) {
            FieldEvaluationAlgorithm evaluationAlgorithm;
            FieldEvaluation evaluation = filter.getEvaluation();
            if (evaluation == null) {
                evaluation = FieldEvaluation.EQUAL;
            }
            if ((evaluationAlgorithm = ALGORITHM_BY_EVALUATION.get((Object)evaluation)) == null) {
                throw new IllegalArgumentException("Unknown field evaluation: " + (Object)((Object)evaluation));
            }
            return object -> evaluationAlgorithm.evaluate(object, filter.getFieldName(), filter.getValue(), filter.getValues(), environment);
        }
        return FilterHelper.getFieldPredicate(subFilter, environment);
    }

    public static <T> List<T> filterList(List<T> list, FieldFiltersInput fieldFilter, DataFetchingEnvironment environment) {
        if (fieldFilter == null || fieldFilter.getFilters().isEmpty()) {
            return list;
        }
        return list.stream().filter(FilterHelper.getFieldPredicate(fieldFilter, FieldEvaluator.forList(environment))).collect(Collectors.toList());
    }

    public static <T> List<T> filterConnection(List<T> list, FieldFiltersInput fieldFilter, DataFetchingEnvironment environment) {
        if (fieldFilter == null || fieldFilter.getFilters().isEmpty()) {
            return list;
        }
        return list.stream().filter(FilterHelper.getFieldPredicate(fieldFilter, FieldEvaluator.forConnection(environment))).collect(Collectors.toList());
    }

    static {
        ALGORITHM_BY_EVALUATION.put(FieldEvaluation.EQUAL, (source, fieldName, fieldValue, fieldValues, environment) -> {
            Object value = environment.getFieldValue(source, fieldName);
            return value != null && value.toString().equals(fieldValue);
        });
        ALGORITHM_BY_EVALUATION.put(FieldEvaluation.DIFFERENT, (source, fieldName, fieldValue, fieldValues, environment) -> !ALGORITHM_BY_EVALUATION.get((Object)FieldEvaluation.EQUAL).evaluate(source, fieldName, fieldValue, fieldValues, environment));
        ALGORITHM_BY_EVALUATION.put(FieldEvaluation.EMPTY, (source, fieldName, fieldValue, fieldValues, environment) -> {
            Object value = environment.getFieldValue(source, fieldName);
            if (value instanceof Connection) {
                return ((Connection)value).getEdges().size() == 0;
            }
            if (value instanceof Collection) {
                return ((Collection)value).size() == 0;
            }
            return value == null;
        });
        ALGORITHM_BY_EVALUATION.put(FieldEvaluation.NOT_EMPTY, (source, fieldName, fieldValue, fieldValues, environment) -> !ALGORITHM_BY_EVALUATION.get((Object)FieldEvaluation.EMPTY).evaluate(source, fieldName, fieldValue, fieldValues, environment));
        ALGORITHM_BY_EVALUATION.put(FieldEvaluation.CONTAINS, (source, fieldName, fieldValue, fieldValues, environment) -> {
            Object value = environment.getFieldValue(source, fieldName);
            return value != null && StringUtils.contains((String)value.toString(), (String)fieldValue);
        });
        ALGORITHM_BY_EVALUATION.put(FieldEvaluation.CONTAINS_IGNORE_CASE, (source, fieldName, fieldValue, fieldValues, environment) -> {
            Object value = environment.getFieldValue(source, fieldName);
            return value != null && StringUtils.containsIgnoreCase((String)value.toString(), (String)fieldValue);
        });
        ALGORITHM_BY_EVALUATION.put(FieldEvaluation.AMONG, (source, fieldName, fieldValue, fieldValues, environment) -> {
            Object value = environment.getFieldValue(source, fieldName);
            return value != null && fieldValues.contains(value.toString());
        });
    }

    @FunctionalInterface
    static interface FieldEvaluationAlgorithm {
        public boolean evaluate(Object var1, String var2, String var3, Collection<String> var4, FieldEvaluator var5);
    }

    static enum FieldEvaluation {
        EQUAL,
        DIFFERENT,
        EMPTY,
        NOT_EMPTY,
        CONTAINS,
        CONTAINS_IGNORE_CASE,
        AMONG;

    }
}

