/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.modules.graphql.provider.dxm.predicate;

import java.util.Collection;
import java.util.function.Predicate;
import org.jahia.modules.graphql.provider.dxm.predicate.MulticriteriaEvaluation;

public class PredicateHelper {
    public static <T> Predicate<T> truePredicate() {
        return object -> true;
    }

    public static <T> Predicate<T> falsePredicate() {
        return object -> false;
    }

    public static <T> Predicate<T> anyPredicate(Collection<Predicate<T>> predicates) {
        return predicates.stream().reduce(Predicate::or).orElse(t -> false);
    }

    public static <T> Predicate<T> allPredicates(Collection<Predicate<T>> predicates) {
        return predicates.stream().reduce(Predicate::and).orElse(t -> false);
    }

    public static <T> Predicate<T> getCombinedPredicate(Collection<Predicate<T>> predicates, MulticriteriaEvaluation multicriteriaEvaluation, MulticriteriaEvaluation defaultMulticriteriaEvaluation) {
        if (multicriteriaEvaluation == null) {
            multicriteriaEvaluation = defaultMulticriteriaEvaluation;
        }
        if (multicriteriaEvaluation == MulticriteriaEvaluation.ALL) {
            return PredicateHelper.allPredicates(predicates);
        }
        if (multicriteriaEvaluation == MulticriteriaEvaluation.ANY) {
            return PredicateHelper.anyPredicate(predicates);
        }
        if (multicriteriaEvaluation == MulticriteriaEvaluation.NONE) {
            return PredicateHelper.anyPredicate(predicates).negate();
        }
        throw new IllegalArgumentException("Unknown multicriteria evaluation: " + (Object)((Object)multicriteriaEvaluation));
    }
}

