/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.modules.graphql.provider.dxm.render;

import graphql.annotations.annotationTypes.GraphQLDescription;
import graphql.annotations.annotationTypes.GraphQLField;
import graphql.annotations.annotationTypes.GraphQLName;
import graphql.annotations.annotationTypes.GraphQLNonNull;
import graphql.annotations.annotationTypes.GraphQLTypeExtension;
import graphql.kickstart.servlet.context.GraphQLServletContext;
import graphql.schema.DataFetchingEnvironment;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.jcr.RepositoryException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import org.jahia.bin.Render;
import org.jahia.modules.graphql.provider.dxm.DataFetchingException;
import org.jahia.modules.graphql.provider.dxm.node.GqlJcrNode;
import org.jahia.modules.graphql.provider.dxm.node.NodeHelper;
import org.jahia.modules.graphql.provider.dxm.node.SpecializedTypesHandler;
import org.jahia.modules.graphql.provider.dxm.render.RenderRequestAttributeInput;
import org.jahia.modules.graphql.provider.dxm.util.ContextUtil;
import org.jahia.services.SpringContextSingleton;
import org.jahia.services.content.JCRContentUtils;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRSessionFactory;
import org.jahia.services.content.decorator.JCRSiteNode;
import org.jahia.services.content.nodetypes.ConstraintsHelper;
import org.jahia.services.render.RenderContext;
import org.jahia.services.render.RenderService;
import org.jahia.services.render.Resource;
import org.jahia.services.uicomponents.bean.editmode.EditConfiguration;
import org.jahia.settings.SettingsBean;

@GraphQLTypeExtension(value=GqlJcrNode.class)
public class RenderNodeExtensions {
    private GqlJcrNode node;

    public RenderNodeExtensions(GqlJcrNode node) {
        this.node = node;
    }

    @GraphQLField
    @GraphQLDescription(value="Returns the first parent of the current node that can be displayed in full page. If no matching node is found, null is returned.")
    public GqlJcrNode getDisplayableNode(DataFetchingEnvironment environment) {
        GraphQLServletContext gqlContext = (GraphQLServletContext)environment.getContext();
        HttpServletRequest httpServletRequest = ContextUtil.getHttpServletRequest(environment.getContext());
        HttpServletResponse httpServletResponse = ContextUtil.getHttpServletResponse(environment.getContext());
        if (httpServletRequest == null || httpServletResponse == null) {
            return null;
        }
        RenderContext context = new RenderContext(httpServletRequest, httpServletResponse, JCRSessionFactory.getInstance().getCurrentUser());
        JCRNodeWrapper node = JCRContentUtils.findDisplayableNode((JCRNodeWrapper)((GqlJcrNode)environment.getSource()).getNode(), (RenderContext)context);
        if (node != null) {
            try {
                return SpecializedTypesHandler.getNode(node);
            }
            catch (RepositoryException e) {
                throw new DataFetchingException(e);
            }
        }
        return null;
    }

    @GraphQLField
    @GraphQLName(value="isDisplayableNode")
    @GraphQLDescription(value="Check if the node as a renderable template associated with it (not a view a template).")
    public boolean isDisplayableNode() {
        try {
            RenderContext context = new RenderContext(null, null, this.node.getNode().getSession().getUser());
            context.setMainResource(new Resource(this.node.getNode(), "html", null, "page"));
            context.setServletPath("/cms/render/live");
            return JCRContentUtils.isADisplayableNode((JCRNodeWrapper)this.node.getNode(), (RenderContext)context);
        }
        catch (RepositoryException e) {
            throw new RuntimeException(e);
        }
    }

    @GraphQLField
    @GraphQLDescription(value="Render URL in ajax mode")
    public String getAjaxRenderUrl() {
        return this.node.getNode().getUrl() + ".ajax";
    }

    @GraphQLField
    @GraphQLDescription(value="Gets the fully rendered content for this node")
    public RenderedNode getRenderedContent(@GraphQLName(value="view") @GraphQLDescription(value="Name of the view (leave null for default)") String view, @GraphQLName(value="templateType") @GraphQLDescription(value="Template type") String templateType, @GraphQLName(value="contextConfiguration") @GraphQLDescription(value="Rendering context configuration") String contextConfiguration, @GraphQLName(value="language") @GraphQLDescription(value="Language") String language, @GraphQLName(value="mainResourcePath") @GraphQLDescription(value="Main resource path") String mainResourcePath, @GraphQLName(value="isEditMode") @GraphQLDescription(value="Is edit mode") Boolean isEditMode, @GraphQLName(value="requestAttributes") @GraphQLDescription(value="Additional request attributes") Collection<RenderRequestAttributeInput> requestAttributes, DataFetchingEnvironment environment) {
        try {
            RenderService renderService = (RenderService)SpringContextSingleton.getBean((String)"RenderService");
            if (contextConfiguration == null) {
                contextConfiguration = "preview";
            }
            if (templateType == null) {
                templateType = "html";
            }
            if (language == null && (language = this.node.getNode().getResolveSite().getDefaultLanguage()) == null) {
                language = "en";
            }
            HttpServletRequest request = ContextUtil.getHttpServletRequest(environment.getContext());
            HttpServletResponse response = ContextUtil.getHttpServletResponse(environment.getContext());
            if (request == null || response == null) {
                throw new RuntimeException("No HttpRequest or HttpResponse");
            }
            if (request instanceof HttpServletRequestWrapper) {
                request = (HttpServletRequest)((HttpServletRequestWrapper)request).getRequest();
            }
            if (requestAttributes != null && requestAttributes.size() > 0) {
                for (RenderRequestAttributeInput requestAttribute : requestAttributes) {
                    request.setAttribute(requestAttribute.getName(), (Object)requestAttribute.getValue());
                }
            }
            JCRNodeWrapper node = NodeHelper.getNodeInLanguage(this.node.getNode(), language);
            if (view == null) {
                String definedView = node.hasProperty("j:view") ? node.getPropertyAsString("j:view") : null;
                view = definedView != null && !definedView.isEmpty() ? definedView : "cm";
            }
            Resource r = new Resource(node, templateType, view, contextConfiguration);
            RenderContext renderContext = new RenderContext(request, response, JCRSessionFactory.getInstance().getCurrentUser());
            if (mainResourcePath != null) {
                JCRNodeWrapper mainNode = NodeHelper.getNodeInLanguage(node.getSession().getNode(mainResourcePath), language);
                renderContext.setMainResource(new Resource(mainNode, templateType, view, contextConfiguration));
            } else {
                renderContext.setMainResource(r);
            }
            if (isEditMode != null && isEditMode.booleanValue()) {
                renderContext.setEditMode(true);
                renderContext.setEditModeConfig((EditConfiguration)SpringContextSingleton.getBean((String)"editmode-jahia-anthracite"));
            }
            renderContext.setServletPath(Render.getRenderServletPath());
            renderContext.setWorkspace(node.getSession().getWorkspace().getName());
            JCRSiteNode site = node.getResolveSite();
            renderContext.setSite(site);
            response.setCharacterEncoding(SettingsBean.getInstance().getCharacterEncoding());
            String res = renderService.render(r, renderContext);
            return new RenderedNode(res, renderContext);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @GraphQLDescription(value="Representation of a static assert")
    public static class StaticAsset {
        private String key;
        private Map<String, String> options;

        public StaticAsset(String key, Map<String, String> options) {
            this.key = key;
            this.options = options;
        }

        @GraphQLField
        @GraphQLDescription(value="Asset key")
        public String getKey() {
            return this.key;
        }

        @GraphQLField
        @GraphQLDescription(value="Asset option")
        public String getOption(@GraphQLName(value="name") @GraphQLDescription(value="Asset option name") @GraphQLNonNull String name) {
            return this.options.get(name);
        }
    }

    @GraphQLDescription(value="Rendering result for a node")
    public static class RenderedNode {
        private String output;
        private RenderContext renderContext;

        public RenderedNode(String output, RenderContext renderContext) {
            this.output = output;
            this.renderContext = renderContext;
        }

        @GraphQLField
        @GraphQLDescription(value="Rendering output")
        public String getOutput() {
            return this.output;
        }

        @GraphQLField
        @GraphQLDescription(value="Contraints on this node")
        public String getConstraints() {
            String constraints = null;
            try {
                constraints = ConstraintsHelper.getConstraints((JCRNodeWrapper)this.renderContext.getMainResource().getNode());
            }
            catch (RepositoryException e) {
                throw new RuntimeException(e);
            }
            return constraints;
        }

        @GraphQLField
        @GraphQLDescription(value="List of static assets")
        public List<StaticAsset> getStaticAssets(@GraphQLName(value="type") @GraphQLDescription(value="Assets type") @GraphQLNonNull String type) {
            Map entries;
            Map staticAssets = (Map)this.renderContext.getRequest().getAttribute("staticAssets");
            if (staticAssets != null && (entries = (Map)staticAssets.get(type)) != null) {
                ArrayList<StaticAsset> result = new ArrayList<StaticAsset>();
                for (Map.Entry filetypeEntries : entries.entrySet()) {
                    String filePath = (String)filetypeEntries.getKey();
                    Map fileOptions = (Map)filetypeEntries.getValue();
                    result.add(new StaticAsset(filePath, fileOptions));
                }
                return result;
            }
            return null;
        }
    }
}

