/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.modules.graphql.provider.dxm.sdl.fetchers;

import graphql.schema.GraphQLDirective;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLList;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLScalarType;
import java.util.Map;
import java.util.stream.Collectors;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import org.apache.commons.lang.StringUtils;
import org.jahia.modules.graphql.provider.dxm.sdl.fetchers.AllFinderDataFetcher;
import org.jahia.modules.graphql.provider.dxm.sdl.fetchers.BooleanFinderDataFetcher;
import org.jahia.modules.graphql.provider.dxm.sdl.fetchers.ByIdFinderDataFetcher;
import org.jahia.modules.graphql.provider.dxm.sdl.fetchers.ByPathFinderDataFetcher;
import org.jahia.modules.graphql.provider.dxm.sdl.fetchers.DateRangeDataFetcher;
import org.jahia.modules.graphql.provider.dxm.sdl.fetchers.Finder;
import org.jahia.modules.graphql.provider.dxm.sdl.fetchers.FinderBaseDataFetcher;
import org.jahia.modules.graphql.provider.dxm.sdl.fetchers.NumberFinder;
import org.jahia.modules.graphql.provider.dxm.sdl.fetchers.NumberFinderDataFetcher;
import org.jahia.modules.graphql.provider.dxm.sdl.fetchers.StringFinderDataFetcher;
import org.jahia.modules.graphql.provider.dxm.sdl.fetchers.WeakreferenceFinder;
import org.jahia.modules.graphql.provider.dxm.sdl.fetchers.WeakreferenceFinderDataFetcher;
import org.jahia.services.content.nodetypes.ExtendedNodeType;
import org.jahia.services.content.nodetypes.ExtendedPropertyDefinition;
import org.jahia.services.content.nodetypes.NodeTypeRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FinderFetchersFactory {
    private static Logger logger = LoggerFactory.getLogger(FinderFetchersFactory.class);

    public static FinderBaseDataFetcher getFetcher(GraphQLFieldDefinition fieldDefinition, String nodeType) {
        String queryName = fieldDefinition.getName().replace("Connection", "");
        Finder finder = new Finder(queryName);
        finder.setType(nodeType);
        for (FetcherType fetcherType : FetcherType.values()) {
            if ((fetcherType.prefix == null || !queryName.startsWith(fetcherType.prefix)) && (fetcherType.suffix == null || !queryName.endsWith(fetcherType.suffix))) continue;
            return FinderFetchersFactory.getFetcherType(finder, fetcherType);
        }
        String definitionPropertyName = FinderFetchersFactory.getDefinitionProperty(queryName);
        String propertyNameInJcr = FinderFetchersFactory.getMappedProperty(definitionPropertyName, fieldDefinition);
        String propertyType = FinderFetchersFactory.getMappedType(definitionPropertyName, propertyNameInJcr, fieldDefinition);
        finder.setProperty(propertyNameInJcr != null ? propertyNameInJcr : definitionPropertyName);
        switch (propertyType) {
            case "Date": {
                return FinderFetchersFactory.getFetcherType(finder, FetcherType.DATE);
            }
            case "Boolean": {
                return FinderFetchersFactory.getFetcherType(finder, FetcherType.BOOLEAN);
            }
            case "BigDecimal": 
            case "BigInteger": 
            case "Long": 
            case "Short": 
            case "Float": 
            case "Int": {
                NumberFinder f = NumberFinder.fromFinder(finder);
                f.setNumberType(propertyType);
                return FinderFetchersFactory.getFetcherType(f, FetcherType.NUMBER);
            }
            case "Weakreference": {
                WeakreferenceFinder weakreferenceFinder = FinderFetchersFactory.getWeakreferenceFinder(finder, fieldDefinition, definitionPropertyName);
                return FinderFetchersFactory.getFetcherType(weakreferenceFinder, FetcherType.WEAKREFERENCE);
            }
        }
        return FinderFetchersFactory.getFetcherType(finder, FetcherType.STRING);
    }

    public static FinderBaseDataFetcher getFetcherType(Finder finder, FetcherType type) {
        switch (type) {
            case ALL: {
                return new AllFinderDataFetcher(finder);
            }
            case ID: {
                return new ByIdFinderDataFetcher(finder);
            }
            case PATH: {
                return new ByPathFinderDataFetcher(finder);
            }
            case DATE: {
                return new DateRangeDataFetcher(finder);
            }
            case BOOLEAN: {
                return new BooleanFinderDataFetcher(finder);
            }
            case NUMBER: {
                return new NumberFinderDataFetcher((NumberFinder)finder);
            }
            case WEAKREFERENCE: {
                return new WeakreferenceFinderDataFetcher((WeakreferenceFinder)finder);
            }
        }
        return new StringFinderDataFetcher(finder);
    }

    private static String getDefinitionProperty(String queryName) {
        return StringUtils.uncapitalize((String)StringUtils.substringAfterLast((String)queryName, (String)"By"));
    }

    private static String getMappedProperty(String definitionPropertyName, GraphQLFieldDefinition fieldDefinition) {
        GraphQLObjectType type = (GraphQLObjectType)((GraphQLList)fieldDefinition.getType()).getWrappedType();
        GraphQLFieldDefinition fd = type.getFieldDefinition(definitionPropertyName);
        if (fd == null) {
            return null;
        }
        GraphQLDirective directive = fd.getDirective("mapping");
        if (directive == null) {
            return null;
        }
        return fd.getDirective("mapping").getArgument("property").getValue().toString();
    }

    private static String getMappedType(String definitionPropertyName, String propertyNameInJcr, GraphQLFieldDefinition fieldDefinition) {
        GraphQLObjectType graphQLType = (GraphQLObjectType)((GraphQLList)fieldDefinition.getType()).getWrappedType();
        GraphQLDirective mappingDirective = graphQLType.getDirective("mapping");
        if (mappingDirective != null) {
            String nodeType = mappingDirective.getArgument("node").getValue().toString();
            ExtendedNodeType type = null;
            try {
                type = NodeTypeRegistry.getInstance().getNodeType(nodeType);
                ExtendedPropertyDefinition propDef = type.getPropertyDefinition(propertyNameInJcr);
                if (propDef != null && 10 == propDef.getRequiredType()) {
                    return "Weakreference";
                }
            }
            catch (NoSuchNodeTypeException e) {
                logger.error("Node type is not found due to", (Throwable)e);
            }
        }
        return graphQLType.getFieldDefinition(definitionPropertyName).getType().getName();
    }

    private static WeakreferenceFinder getWeakreferenceFinder(Finder finder, GraphQLFieldDefinition fieldDefinition, String definitionPropertyName) {
        WeakreferenceFinder weakrefFinder = WeakreferenceFinder.fromFinder(finder);
        GraphQLObjectType graphQLType = (GraphQLObjectType)((GraphQLList)fieldDefinition.getType()).getWrappedType();
        GraphQLFieldDefinition field = graphQLType.getFieldDefinition(definitionPropertyName);
        GraphQLOutputType fieldType = field.getType();
        GraphQLDirective directive = fieldType.getChildren().stream().filter(type -> type instanceof GraphQLDirective && type.getName().equals("mapping") && ((GraphQLDirective)type).getArgument("node") != null).findFirst().orElse(null);
        if (directive != null) {
            String nodeTypeOfWeakreference = directive.getArgument("node").getValue().toString();
            weakrefFinder.setReferencedType(nodeTypeOfWeakreference);
            Map<String, String> referenceProps = fieldType.getChildren().stream().filter(type -> type instanceof GraphQLFieldDefinition && ((GraphQLFieldDefinition)type).getType() instanceof GraphQLScalarType && ((GraphQLFieldDefinition)type).getDirective("mapping") != null).collect(Collectors.toMap(type -> type.getName(), type -> ((GraphQLFieldDefinition)type).getDirective("mapping").getArgument("property").getValue().toString()));
            weakrefFinder.setReferenceTypeProps(referenceProps);
            weakrefFinder.setReferencedTypeSDLName(fieldType.getName());
        }
        return weakrefFinder;
    }

    public static enum FetcherType {
        ALL("all", null),
        ID(null, "ById"),
        PATH(null, "ByPath"),
        DATE,
        NUMBER,
        BOOLEAN,
        STRING,
        WEAKREFERENCE;

        String prefix;
        String suffix;

        private FetcherType() {
        }

        private FetcherType(String prefix, String suffix) {
            this.prefix = prefix;
            this.suffix = suffix;
        }

        public String getName(String base) {
            return (this.prefix != null ? this.prefix + base : StringUtils.uncapitalize((String)base)) + (this.suffix != null ? this.suffix : "");
        }

        public String getPrefix() {
            return this.prefix;
        }

        public String getSuffix() {
            return this.suffix;
        }
    }
}

