/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.modules.graphql.provider.dxm.sdl.fetchers;

import graphql.Scalars;
import graphql.schema.DataFetchingEnvironment;
import graphql.schema.GraphQLArgument;
import graphql.schema.GraphQLInputType;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.jahia.modules.graphql.provider.dxm.node.GqlJcrNode;
import org.jahia.modules.graphql.provider.dxm.predicate.FieldEvaluator;
import org.jahia.modules.graphql.provider.dxm.predicate.FieldSorterInput;
import org.jahia.modules.graphql.provider.dxm.predicate.SorterHelper;
import org.jahia.modules.graphql.provider.dxm.sdl.SDLUtil;
import org.jahia.modules.graphql.provider.dxm.sdl.fetchers.Finder;
import org.jahia.modules.graphql.provider.dxm.sdl.fetchers.FinderBaseDataFetcher;
import org.jahia.modules.graphql.provider.dxm.sdl.parsing.SDLSchemaService;
import org.jahia.osgi.BundleUtils;

public abstract class FinderListDataFetcher
extends FinderBaseDataFetcher {
    private static final String SORT_BY = "sortBy";
    private static final String FIELD_NAME = "fieldName";
    private static final String SORT_TYPE = "sortType";
    private static final String IGNORE_CASE = "ignoreCase";

    public FinderListDataFetcher(String type, Finder finder) {
        super(type, finder);
    }

    public FinderListDataFetcher(String type) {
        this(type, null);
    }

    @Override
    protected List<GraphQLArgument> getDefaultArguments() {
        SDLSchemaService sdlSchemaService = (SDLSchemaService)BundleUtils.getOsgiService(SDLSchemaService.class, null);
        ArrayList<GraphQLArgument> list = new ArrayList<GraphQLArgument>();
        list.add(GraphQLArgument.newArgument().name("preview").type((GraphQLInputType)Scalars.GraphQLBoolean).description("Return content from live or default workspace").defaultValue((Object)false).build());
        list.add(GraphQLArgument.newArgument().name("language").type((GraphQLInputType)Scalars.GraphQLString).description("Content language, defaults to English").defaultValue((Object)"en").build());
        if (sdlSchemaService == null) {
            return list;
        }
        list.add(GraphQLArgument.newArgument().name(SORT_BY).description("Sort filter object").type(sdlSchemaService.getSDLSpecialInputType(SDLSchemaService.SpecialInputTypes.FIELD_SORTER_INPUT.getName())).build());
        return list;
    }

    protected Stream<GqlJcrNode> resolveCollection(Stream<GqlJcrNode> stream, DataFetchingEnvironment environment) {
        FieldSorterInput sorterInput = this.getFieldSorterInput(environment);
        if (sorterInput != null) {
            if (environment.getFieldType().getName() != null && environment.getFieldType().getName().endsWith("Connection")) {
                return stream.sorted(SorterHelper.getFieldComparator(sorterInput, FieldEvaluator.forConnection(environment)));
            }
            return stream.sorted(SorterHelper.getFieldComparator(sorterInput, FieldEvaluator.forList(environment)));
        }
        return stream;
    }

    private FieldSorterInput getFieldSorterInput(DataFetchingEnvironment environment) {
        Map sortByFilter = (Map)SDLUtil.getArgument(SORT_BY, environment);
        return sortByFilter != null ? new FieldSorterInput((String)sortByFilter.get(FIELD_NAME), (SorterHelper.SortType)((Object)sortByFilter.get(SORT_TYPE)), (Boolean)sortByFilter.get(IGNORE_CASE)) : null;
    }

    @Override
    public abstract Object get(DataFetchingEnvironment var1);

    public abstract Stream<GqlJcrNode> getStream(DataFetchingEnvironment var1);
}

