/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.modules.graphql.provider.dxm.sdl.fetchers;

import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import java.util.ArrayList;
import javax.jcr.RepositoryException;
import org.apache.commons.lang.StringUtils;
import org.jahia.modules.graphql.provider.dxm.node.GqlJcrNode;
import org.jahia.modules.graphql.provider.dxm.node.NodeHelper;
import org.jahia.modules.graphql.provider.dxm.sdl.SDLUtil;
import org.jahia.modules.graphql.provider.dxm.sdl.fetchers.Field;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRPropertyWrapper;
import org.jahia.services.content.JCRValueWrapper;

public class PropertiesDataFetcher
implements DataFetcher<Object> {
    private Field field;

    public PropertiesDataFetcher(Field field) {
        this.field = field;
    }

    public Object get(DataFetchingEnvironment dataFetchingEnvironment) {
        try {
            JCRPropertyWrapper property;
            GqlJcrNode node = (GqlJcrNode)dataFetchingEnvironment.getSource();
            JCRNodeWrapper jcrNodeWrapper = node.getNode();
            if (SDLUtil.getArgument("language", dataFetchingEnvironment) != null) {
                jcrNodeWrapper = NodeHelper.getNodeInLanguage(jcrNodeWrapper, (String)SDLUtil.getArgument("language", dataFetchingEnvironment));
            }
            if ((property = this.getProperty(jcrNodeWrapper)) == null) {
                return null;
            }
            if (!property.isMultiple()) {
                return this.getString(property.getValue());
            }
            ArrayList<Object> res = new ArrayList<Object>();
            for (JCRValueWrapper value : property.getValues()) {
                res.add(this.getString(value));
            }
            return res;
        }
        catch (RepositoryException e) {
            throw new RuntimeException(e);
        }
    }

    private JCRPropertyWrapper getProperty(JCRNodeWrapper jcrNodeWrapper) throws RepositoryException {
        String[] propertyNames;
        JCRPropertyWrapper property = null;
        for (String propertyName : propertyNames = StringUtils.split((String)this.field.getProperty(), (char)'.')) {
            property = null;
            if (jcrNodeWrapper == null) continue;
            if (jcrNodeWrapper.hasNode(propertyName)) {
                jcrNodeWrapper = jcrNodeWrapper.getNode(propertyName);
                continue;
            }
            if (!jcrNodeWrapper.hasProperty(propertyName) || (property = jcrNodeWrapper.getProperty(propertyName)).getType() != 9 && property.getType() != 10) continue;
            try {
                jcrNodeWrapper = property.getValue().getNode();
            }
            catch (RepositoryException e) {
                jcrNodeWrapper = null;
            }
        }
        return property;
    }

    private Object getString(JCRValueWrapper value) throws RepositoryException {
        switch (value.getType()) {
            case 6: {
                return value.getBoolean();
            }
            case 3: 
            case 5: 
            case 12: {
                return value.getLong();
            }
            case 4: {
                return value.getDouble();
            }
            case 2: {
                return value.getBinary().getSize();
            }
        }
        return value.getString();
    }
}

