/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.modules.graphql.provider.dxm.sdl.fetchers;

import graphql.annotations.connection.ConnectionFetcher;
import graphql.relay.Connection;
import graphql.relay.ConnectionCursor;
import graphql.relay.DefaultConnection;
import graphql.relay.DefaultConnectionCursor;
import graphql.relay.DefaultPageInfo;
import graphql.relay.Edge;
import graphql.relay.PageInfo;
import graphql.schema.DataFetchingEnvironment;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Stream;
import org.jahia.modules.graphql.provider.dxm.DXGraphQLProvider;
import org.jahia.modules.graphql.provider.dxm.DataFetchingException;
import org.jahia.modules.graphql.provider.dxm.node.GqlJcrNode;
import org.jahia.modules.graphql.provider.dxm.relay.DXConnection;
import org.jahia.modules.graphql.provider.dxm.relay.DXEdge;
import org.jahia.modules.graphql.provider.dxm.relay.DXPageInfo;
import org.jahia.modules.graphql.provider.dxm.relay.DXPaginatedData;
import org.jahia.modules.graphql.provider.dxm.relay.PaginationHelper;
import org.jahia.modules.graphql.provider.dxm.sdl.fetchers.FinderListDataFetcher;

public class SDLPaginatedDataConnectionFetcher<T>
implements ConnectionFetcher<T> {
    private FinderListDataFetcher fetcher;

    public SDLPaginatedDataConnectionFetcher(FinderListDataFetcher fetcher) {
        this.fetcher = fetcher;
    }

    public Connection<T> get(DataFetchingEnvironment environment) throws Exception {
        PaginationHelper.Arguments arguments;
        Stream<GqlJcrNode> l = this.fetcher.getStream(environment);
        DXPaginatedData<Object> paginatedData = PaginationHelper.paginate(l, n -> PaginationHelper.encodeCursor(((GqlJcrNode)n).getUuid()), arguments = PaginationHelper.parseArguments(environment));
        if (paginatedData == null) {
            return new DefaultConnection(Collections.emptyList(), (PageInfo)new DefaultPageInfo(null, null, false, false));
        }
        List<Edge<T>> edges = this.buildEdges(paginatedData);
        DXPageInfo pageInfo = this.getPageInfo(edges, paginatedData);
        Class<DXConnection<?>> connectionType = DXGraphQLProvider.getInstance().getConnectionType(environment.getExecutionStepInfo().getFieldDefinition().getType().getName());
        if (connectionType != null) {
            try {
                return (Connection)connectionType.getConstructor(List.class, PageInfo.class).newInstance(new Object[]{edges, pageInfo});
            }
            catch (ReflectiveOperationException e) {
                throw new DataFetchingException(e);
            }
        }
        return new DXConnection<T>(edges, (PageInfo)pageInfo);
    }

    private DXPageInfo getPageInfo(List<Edge<T>> edges, DXPaginatedData<T> paginatedData) {
        return new DXPageInfo(!edges.isEmpty() ? edges.get(0).getCursor() : null, !edges.isEmpty() ? edges.get(edges.size() - 1).getCursor() : null, paginatedData);
    }

    private List<Edge<T>> buildEdges(DXPaginatedData<T> paginatedData) {
        Iterator data = paginatedData.iterator();
        ArrayList<Edge<T>> edges = new ArrayList<Edge<T>>();
        while (data.hasNext()) {
            Object entity = data.next();
            edges.add((Edge<T>)new DXEdge(entity, paginatedData.getIndex(entity), (ConnectionCursor)new DefaultConnectionCursor(paginatedData.getCursor(entity))));
        }
        return edges;
    }
}

