/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.modules.graphql.provider.dxm.sdl.parsing;

import graphql.language.NamedNode;
import graphql.language.NodeParentTree;
import graphql.schema.DataFetcher;
import graphql.schema.GraphQLArgument;
import graphql.schema.GraphQLDirective;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLList;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLOutputType;
import graphql.schema.idl.SchemaDirectiveWiring;
import graphql.schema.idl.SchemaDirectiveWiringEnvironment;
import java.util.List;
import org.jahia.modules.graphql.provider.dxm.sdl.fetchers.Field;
import org.jahia.modules.graphql.provider.dxm.sdl.fetchers.FinderListDataFetcher;
import org.jahia.modules.graphql.provider.dxm.sdl.fetchers.PropertiesDataFetcherFactory;
import org.jahia.modules.graphql.provider.dxm.sdl.fetchers.SDLPaginatedDataConnectionFetcher;
import org.jahia.modules.graphql.provider.dxm.sdl.parsing.ConnectionHelper;
import org.jahia.modules.graphql.provider.dxm.sdl.parsing.SDLSchemaService;
import org.jahia.osgi.BundleUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MappingDirectiveWiring
implements SchemaDirectiveWiring {
    private static Logger logger = LoggerFactory.getLogger(MappingDirectiveWiring.class);

    public GraphQLObjectType onObject(SchemaDirectiveWiringEnvironment<GraphQLObjectType> environment) {
        return (GraphQLObjectType)environment.getElement();
    }

    public GraphQLFieldDefinition onField(SchemaDirectiveWiringEnvironment<GraphQLFieldDefinition> environment) {
        GraphQLFieldDefinition def = (GraphQLFieldDefinition)environment.getElement();
        GraphQLDirective directive = environment.getDirective();
        Field field = new Field(def.getName());
        field.setProperty(directive.getArgument("property").getValue().toString());
        field.setType(def.getType().getName());
        logger.debug("field name {} ", (Object)field.getName());
        logger.debug("field type {} ", (Object)field.getType());
        SDLSchemaService service = (SDLSchemaService)BundleUtils.getOsgiService(SDLSchemaService.class, null);
        if (service != null) {
            String parentType = ((NamedNode)((NodeParentTree)environment.getNodeParentTree().getParentInfo().get()).getNode()).getName();
            String key = parentType + "." + def.getName();
            if (service.getConnectionFieldNameToSDLType().containsKey(key)) {
                ConnectionHelper.ConnectionTypeInfo conInfo = service.getConnectionFieldNameToSDLType().get(key);
                GraphQLOutputType node = (GraphQLOutputType)((GraphQLList)def.getType()).getWrappedType();
                GraphQLObjectType connectionType = ConnectionHelper.getOrCreateConnection(service, node, conInfo.getMappedToType());
                DataFetcher typeFetcher = PropertiesDataFetcherFactory.getFetcher(def, field);
                List<GraphQLArgument> args = service.getRelay().getConnectionFieldArguments();
                SDLPaginatedDataConnectionFetcher fetcher = new SDLPaginatedDataConnectionFetcher((FinderListDataFetcher)typeFetcher);
                def.getDirectives().remove(0);
                return GraphQLFieldDefinition.newFieldDefinition((GraphQLFieldDefinition)def).type((GraphQLOutputType)connectionType).dataFetcher(fetcher).argument(args).build();
            }
        }
        return GraphQLFieldDefinition.newFieldDefinition((GraphQLFieldDefinition)def).dataFetcher(PropertiesDataFetcherFactory.getFetcher(def, field)).build();
    }
}

