/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.modules.graphql.provider.dxm.sdl.registration;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jahia.modules.external.modules.osgi.ModulesSourceMonitor;
import org.jahia.modules.graphql.provider.dxm.DXGraphQLProvider;
import org.jahia.modules.graphql.provider.dxm.sdl.monitor.SDLFileSourceMonitor;
import org.jahia.modules.graphql.provider.dxm.sdl.registration.SDLRegistrationService;
import org.jahia.osgi.BundleUtils;
import org.jahia.registries.ServicesRegistry;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.SynchronousBundleListener;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={SDLRegistrationService.class}, immediate=true)
public class SDLRegistrationImpl
implements SDLRegistrationService,
SynchronousBundleListener {
    private static final String EXTERNAL_PROVIDER_MODULES = "external-provider-modules";
    private static final Logger logger = LoggerFactory.getLogger(SDLRegistrationImpl.class);
    private static final String JAHIA_SOURCE_FOLDERS = "Jahia-Source-Folders";
    private static final String SRC_MAIN_RESOURCES = "/src/main/resources/";
    private static final String GRAPHQL_EXTENSION_SDL = "META-INF/graphql-extension.sdl";
    private static Map<Integer, String> status = new HashMap<Integer, String>();
    private final Map<String, URL> sdlResources = new ConcurrentHashMap<String, URL>();
    private BundleContext bundleContext;
    private ComponentContext componentContext;
    private ServiceRegistration<ModulesSourceMonitor> serviceRegistration = null;

    @Activate
    public void activate(ComponentContext componentContext, BundleContext bundleContext) {
        this.bundleContext = bundleContext;
        this.componentContext = componentContext;
        this.bundleContext.addBundleListener((BundleListener)this);
        this.registerSourceMonitorService();
        this.registerAllBundles(this.isSourcesAvailable());
        BundleUtils.getBundleBySymbolicName((String)EXTERNAL_PROVIDER_MODULES, null);
    }

    @Deactivate
    public void deactivate() {
        this.unregisterSourceMonitorService();
    }

    @Override
    public Map<String, URL> getSDLResources() {
        return this.sdlResources;
    }

    private boolean isSourcesAvailable() {
        return ServicesRegistry.getInstance().getJahiaTemplateManagerService().getTemplatePackageById(EXTERNAL_PROVIDER_MODULES) != null;
    }

    private void registerAllBundles(boolean sourcesAvailable) {
        this.sdlResources.clear();
        for (Bundle bundle : this.bundleContext.getBundles()) {
            this.checkForSDLResourceInBundle(bundle, bundle.getState() == 32, sourcesAvailable);
        }
    }

    public void bundleChanged(BundleEvent event) {
        int eventType = event.getType();
        Bundle bundle = event.getBundle();
        boolean restart = false;
        if (eventType == 2 || eventType == 4) {
            if (bundle.getSymbolicName().equals(EXTERNAL_PROVIDER_MODULES)) {
                logger.debug("received event {} for bundle {}, reloading all sdl", (Object)status.get(eventType), (Object)bundle.getSymbolicName());
                this.registerAllBundles(eventType == 2);
                restart = true;
            } else if (this.checkForSDLResourceInBundle(bundle, eventType == 2, this.isSourcesAvailable())) {
                logger.debug("received event {} for bundle {} ", (Object)status.get(eventType), (Object)bundle.getSymbolicName());
                restart = true;
            }
        }
        if (restart) {
            this.componentContext.disableComponent(DXGraphQLProvider.class.getName());
            this.componentContext.enableComponent(DXGraphQLProvider.class.getName());
        }
    }

    private boolean checkForSDLResourceInBundle(Bundle bundle, boolean register, boolean withSources) {
        URL url;
        if (BundleUtils.isJahiaBundle((Bundle)bundle) && bundle.getState() >= 4 && (url = bundle.getResource(GRAPHQL_EXTENSION_SDL)) != null) {
            logger.debug("get bundle schema {}", (Object)url.getPath());
            if (withSources) {
                url = this.getSourcesUrl(bundle, url);
            }
            this.handleSDLResource(register, bundle.getSymbolicName(), url);
            return true;
        }
        return false;
    }

    private URL getSourcesUrl(Bundle bundle, URL url) {
        File file;
        String sourcesFolder = (String)bundle.getHeaders().get(JAHIA_SOURCE_FOLDERS);
        if (sourcesFolder != null && (file = new File(sourcesFolder + SRC_MAIN_RESOURCES + GRAPHQL_EXTENSION_SDL)).exists()) {
            try {
                url = file.toURI().toURL();
            }
            catch (MalformedURLException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        return url;
    }

    private void handleSDLResource(boolean register, String bundleName, URL sdlResource) {
        if (register) {
            if (!this.sdlResources.containsKey(bundleName)) {
                logger.debug("add new type registry for {}", (Object)bundleName);
                this.sdlResources.put(bundleName, sdlResource);
            }
        } else if (this.sdlResources.containsKey(bundleName)) {
            logger.debug("remove type registry for {}", (Object)bundleName);
            this.sdlResources.remove(bundleName);
        }
    }

    private void registerSourceMonitorService() {
        block2: {
            try {
                this.serviceRegistration = this.bundleContext.registerService(ModulesSourceMonitor.class, (Object)new SDLFileSourceMonitor(this.bundleContext, this.componentContext), null);
            }
            catch (NoClassDefFoundError e) {
                if (!logger.isDebugEnabled()) break block2;
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    private void unregisterSourceMonitorService() {
        if (this.serviceRegistration != null) {
            this.serviceRegistration.unregister();
        }
    }

    static {
        status.put(1, "installed");
        status.put(16, "uninstalled");
        status.put(32, "resolved");
        status.put(64, "unresolved");
        status.put(2, "started");
        status.put(128, "starting");
        status.put(4, "stopped");
        status.put(256, "started");
        status.put(8, "updated");
    }
}

