/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.modules.graphql.provider.dxm.security;

import graphql.schema.DataFetchingEnvironment;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.jahia.modules.graphql.provider.dxm.DataFetchingException;
import org.jahia.modules.graphql.provider.dxm.util.ContextUtil;
import org.jahia.osgi.BundleUtils;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.securityfilter.PermissionService;

public class PermissionHelper {
    private PermissionHelper() {
    }

    public static boolean hasPermission(JCRNodeWrapper node, DataFetchingEnvironment environment) {
        if (ContextUtil.getHttpServletRequest(environment.getContext()) != null) {
            PermissionService permissionService = (PermissionService)BundleUtils.getOsgiService(PermissionService.class, null);
            if (permissionService == null) {
                throw new DataFetchingException("Could not find permission service to validate security access. Blocking access to data.");
            }
            try {
                return permissionService.hasPermission("graphql." + environment.getParentType().getName() + "." + environment.getFieldDefinition().getName(), (Node)node);
            }
            catch (RepositoryException e) {
                throw new DataFetchingException(e);
            }
        }
        return true;
    }
}

