/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.modules.graphql.provider.dxm.user;

import graphql.annotations.annotationTypes.GraphQLDescription;

@GraphQLDescription(value="Principal type")
public enum PrincipalType {
    USER("u"),
    GROUP("g");

    private final String principalType;

    private PrincipalType(String principalType) {
        this.principalType = principalType;
    }

    public String getValue() {
        return this.principalType;
    }

    public String getPrincipalKey(String principalName) {
        return String.join((CharSequence)":", this.getValue(), principalName);
    }

    public static boolean isUser(String principalKey) {
        return principalKey != null && principalKey.startsWith(USER.getValue() + ":");
    }

    public static boolean isGroup(String principalKey) {
        return principalKey != null && principalKey.startsWith(GROUP.getValue() + ":");
    }

    public static PrincipalType getByValue(String type) {
        if (USER.getValue().equals(type)) {
            return USER;
        }
        if (GROUP.getValue().equals(type)) {
            return GROUP;
        }
        return null;
    }
}

