/*
 * MIT License
 *
 * Copyright (c) 2022 Jahia Forge - Code Repository
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */
package org.jahia.modules.jahiadashboard.graphql;

import graphql.annotations.annotationTypes.GraphQLDescription;
import graphql.annotations.annotationTypes.GraphQLField;

public class GqlModule {

    private String id;
    private String name;
    private String description;
    private String version;
    private long lastModified;
    private boolean inDevelopment;

    public GqlModule() {
    }

    public GqlModule(String id, String name, String description, String version, long lastModified, boolean inDevelopment) {
        this.id = id;
        this.name = name;
        this.description = description;
        this.version = version;
        this.lastModified = lastModified;
        this.inDevelopment = inDevelopment;
    }

    @GraphQLField
    @GraphQLDescription("Unique identifier for the module")
    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @GraphQLField
    @GraphQLDescription("User facing name for the module")
    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @GraphQLField
    @GraphQLDescription("User facing description for the module")
    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @GraphQLField
    @GraphQLDescription("Version number for the module")
    public String getVersion() {
        return version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    @GraphQLField
    @GraphQLDescription("Bundle last modification date")
    public long getLastModified() {
        return lastModified;
    }

    public void setLastModified(long lastModified) {
        this.lastModified = lastModified;
    }

    @GraphQLField
    @GraphQLDescription("If the module is in development, mostly because the sources have been downloaded.")
    public boolean isInDevelopment() {
        return inDevelopment;
    }

    public void setInDevelopment(boolean inDevelopment) {
        this.inDevelopment = inDevelopment;
    }
}
