/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.modules.apitokens.core;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.jcr.RepositoryException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.jahia.api.usermanager.JahiaUserManagerService;
import org.jahia.bin.filters.CompositeFilter;
import org.jahia.modules.apitokens.TokenDetails;
import org.jahia.modules.apitokens.TokenService;
import org.jahia.params.valves.AuthValveContext;
import org.jahia.params.valves.BaseAuthValve;
import org.jahia.pipelines.Pipeline;
import org.jahia.pipelines.PipelineException;
import org.jahia.pipelines.valves.Valve;
import org.jahia.pipelines.valves.ValveContext;
import org.jahia.services.content.JCRTemplate;
import org.jahia.services.content.decorator.JCRUserNode;
import org.jahia.services.securityfilter.PermissionService;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;
import org.osgi.service.component.annotations.ServiceScope;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={Valve.class}, immediate=true, scope=ServiceScope.SINGLETON)
public class TokenAuthValve
extends BaseAuthValve {
    public static final String API_TOKEN = "APIToken";
    private static final Logger logger = LoggerFactory.getLogger(TokenAuthValve.class);
    private Pipeline authPipeline;
    private TokenService tokenService;
    private JahiaUserManagerService userManagerService;
    private PermissionService permissionService;
    private Set<String> urlPatterns = new HashSet<String>();

    @Reference(service=Pipeline.class, target="(type=authentication)")
    public void setAuthPipeline(Pipeline authPipeline) {
        this.authPipeline = authPipeline;
    }

    @Reference
    public void setTokenService(TokenService tokenService) {
        this.tokenService = tokenService;
    }

    @Reference
    public void setUserManagerService(JahiaUserManagerService userManagerService) {
        this.userManagerService = userManagerService;
    }

    @Reference(service=HttpServlet.class, target="(allow-api-token=true)", cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    public void addServlet(ServiceReference<HttpServlet> servlet) {
        this.urlPatterns.add("/modules" + servlet.getProperty("alias"));
    }

    public void removeServlet(ServiceReference<HttpServlet> servlet) {
        this.urlPatterns.remove("/modules" + servlet.getProperty("alias"));
    }

    @Reference(cardinality=ReferenceCardinality.OPTIONAL)
    public void setPermissionService(PermissionService permissionService) {
        this.permissionService = permissionService;
    }

    @Activate
    public void activate(Map<String, ?> props) {
        this.setId("patValve");
        if (props.get("urlPatterns") != null) {
            this.urlPatterns.addAll(Arrays.asList(StringUtils.split((String)((String)props.get("urlPatterns")), (String)",")));
        }
        this.removeValve(this.authPipeline);
        this.addValve(this.authPipeline, 0, null, null);
    }

    @Deactivate
    public void deactivate() {
        this.removeValve(this.authPipeline);
    }

    public void invoke(Object o, ValveContext valveContext) throws PipelineException {
        AuthValveContext authValveContext = (AuthValveContext)o;
        HttpServletRequest request = authValveContext.getRequest();
        String uri = request.getRequestURI().substring(request.getContextPath().length());
        if (this.urlPatterns.stream().anyMatch(urlPattern -> CompositeFilter.matchFiltersURL((String)urlPattern, (String)uri))) {
            try {
                String authorization = request.getHeader("Authorization");
                if (authorization != null && authorization.contains(API_TOKEN)) {
                    String token = StringUtils.substringAfter((String)authorization, (String)API_TOKEN).trim();
                    JCRTemplate.getInstance().doExecuteWithSystemSession(session -> {
                        TokenDetails details = this.tokenService.verifyToken(token, session);
                        logger.debug("Received token {}", (Object)details);
                        if (details != null && details.isValid()) {
                            JCRUserNode user = this.userManagerService.lookupUserByPath(details.getUserPath());
                            authValveContext.setShouldStoreAuthInSession(false);
                            authValveContext.getSessionFactory().setCurrentUser(user.getJahiaUser());
                            if (this.permissionService != null) {
                                this.permissionService.addScopes(details.getScopes(), request);
                            }
                        }
                        return null;
                    });
                }
            }
            catch (RepositoryException e) {
                throw new PipelineException((Throwable)e);
            }
        }
        valveContext.invokeNext(o);
    }
}

