/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.modules.apitokens.core;

import java.security.SecureRandom;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.id.uuid.UUID;
import org.apache.commons.id.uuid.VersionFourGenerator;

public final class TokenUtils {
    private static final int KEY_SIZE = 16;
    private static final int SECRET_SIZE = 16;
    private Base64 base64 = new Base64();
    private SecureRandom random = new SecureRandom();
    private VersionFourGenerator generator = new VersionFourGenerator();

    private TokenUtils() {
    }

    public static TokenUtils getInstance() {
        return InstanceHolder.instance;
    }

    public String generateToken() {
        byte[] b = new byte[32];
        UUID key = (UUID)this.generator.nextIdentifier();
        byte[] secret = new byte[16];
        this.random.nextBytes(secret);
        System.arraycopy(key.getRawBytes(), 0, b, 0, 16);
        System.arraycopy(secret, 0, b, 16, 16);
        return this.base64.encodeToString(b);
    }

    public String getKey(String token) {
        return new UUID(this.getPart(token, 0, 16)).toString();
    }

    public byte[] getSecret(String token) {
        return this.getPart(token, 16, 16);
    }

    public String getDigestedSecret(String token) {
        byte[] part = this.getPart(token, 16, 16);
        byte[] digested = DigestUtils.getDigest((String)"SHA-256").digest(part);
        return this.base64.encodeAsString(digested);
    }

    private byte[] getPart(String token, int offset, int length) {
        byte[] b = this.base64.decode(token);
        byte[] part = new byte[length];
        if (b.length >= offset + length) {
            System.arraycopy(b, offset, part, 0, length);
        }
        return part;
    }

    private static class InstanceHolder {
        public static final TokenUtils instance = new TokenUtils();

        private InstanceHolder() {
        }
    }
}

