/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.modules.apitokens.core;

import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Iterator;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import org.jahia.api.usermanager.JahiaUserManagerService;
import org.jahia.modules.apitokens.TokenBuilder;
import org.jahia.modules.apitokens.TokenDetails;
import org.jahia.modules.apitokens.TokenService;
import org.jahia.modules.apitokens.core.TokenBuilderImpl;
import org.jahia.modules.apitokens.core.TokenDetailsImpl;
import org.jahia.modules.apitokens.core.TokenUtils;
import org.jahia.services.content.JCRContentUtils;
import org.jahia.services.content.JCRNodeIteratorWrapper;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.decorator.JCRUserNode;
import org.jahia.services.query.QueryWrapper;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.touk.throwing.ThrowingFunction;
import pl.touk.throwing.exception.WrappedException;

@Component(immediate=true, service={TokenService.class})
public class TokensServiceImpl
implements TokenService {
    public static final String PATNT_TOKENS = "patnt:tokens";
    public static final String PATNT_TOKEN = "patnt:token";
    public static final String TOKENS = "tokens";
    public static final String KEY = "key";
    public static final String DIGEST = "digest";
    public static final String ACTIVE = "active";
    public static final String EXPIRATION_DATE = "expirationDate";
    public static final String SCOPES = "scopes";
    private static final Logger logger = LoggerFactory.getLogger(TokensServiceImpl.class);
    private JahiaUserManagerService userManagerService;

    @Reference
    public void setUserManagerService(JahiaUserManagerService userManagerService) {
        this.userManagerService = userManagerService;
    }

    @Override
    public TokenBuilder tokenBuilder(String userPath, String name, JCRSessionWrapper currentUserSession) {
        TokenDetailsImpl details = new TokenDetailsImpl(userPath, name);
        return new TokenBuilderImpl(details, (ThrowingFunction<String, String, RepositoryException>)((ThrowingFunction)token -> this.createToken((String)token, details, currentUserSession)));
    }

    private String createToken(String token, TokenDetailsImpl tokenDetails, JCRSessionWrapper session) throws RepositoryException {
        String key;
        if (token == null) {
            token = TokenUtils.getInstance().generateToken();
        }
        if (this.getTokenDetails(key = TokenUtils.getInstance().getKey(token), session) != null) {
            throw new IllegalArgumentException("token already exists");
        }
        String digestedSecret = TokenUtils.getInstance().getDigestedSecret(token);
        JCRUserNode userNode = this.userManagerService.lookupUserByPath(tokenDetails.getUserPath(), session);
        if (userNode == null) {
            throw new IllegalArgumentException("invalid user");
        }
        JCRNodeWrapper tokens = this.getTokensNode(userNode);
        JCRNodeWrapper tokenNode = tokens.addNode(tokenDetails.getName(), PATNT_TOKEN);
        tokenNode.setProperty(KEY, key);
        tokenNode.setProperty(DIGEST, digestedSecret);
        tokenNode.setProperty(ACTIVE, tokenDetails.isActive());
        tokenNode.setProperty(EXPIRATION_DATE, tokenDetails.getExpirationDate());
        if (tokenDetails.getScopes() != null) {
            tokenNode.setProperty(SCOPES, (Value[])tokenDetails.getScopes().stream().map(s -> session.getValueFactory().createValue(s)).toArray(Value[]::new));
        }
        logger.info("New token generated {}", (Object)this.getTokenDetails(tokenNode));
        return token;
    }

    @Override
    public TokenDetails verifyToken(String token, JCRSessionWrapper session) throws RepositoryException {
        String digestedSecret;
        TokenDetails tokenDetails = this.getTokenDetails(TokenUtils.getInstance().getKey(token), session);
        if (tokenDetails != null && (digestedSecret = TokenUtils.getInstance().getDigestedSecret(token)).equals(tokenDetails.getDigest())) {
            return tokenDetails;
        }
        return null;
    }

    @Override
    public TokenDetails getTokenDetails(String key, JCRSessionWrapper session) throws RepositoryException {
        return this.getTokenDetails(this.getTokenNode(key, session));
    }

    @Override
    public TokenDetails getTokenDetails(String userPath, String tokenName, JCRSessionWrapper session) throws RepositoryException {
        QueryWrapper q = session.getWorkspace().getQueryManager().createQuery("select * from [patnt:token] where isdescendantnode('" + JCRContentUtils.sqlEncode((String)userPath) + "') and localname()='" + JCRContentUtils.sqlEncode((String)tokenName) + "'", "JCR-SQL2");
        NodeIterator ni = q.execute().getNodes();
        if (ni.hasNext()) {
            return this.getTokenDetails((JCRNodeWrapper)ni.nextNode());
        }
        return null;
    }

    @Override
    public Stream<TokenDetails> getTokensDetails(String userPath, JCRSessionWrapper session) throws RepositoryException {
        String query = userPath == null ? "select * from [patnt:token]" : "select * from [patnt:token] where isdescendantnode('" + JCRContentUtils.sqlEncode((String)userPath) + "')";
        QueryWrapper q = session.getWorkspace().getQueryManager().createQuery(query, "JCR-SQL2");
        Iterator nodes = ((JCRNodeIteratorWrapper)q.execute().getNodes()).iterator();
        try {
            return StreamSupport.stream(Spliterators.spliteratorUnknownSize(nodes, 16), false).map(ThrowingFunction.unchecked(this::getTokenDetails));
        }
        catch (WrappedException e) {
            if (e.getCause() instanceof RepositoryException) {
                throw (RepositoryException)e.getCause();
            }
            throw e;
        }
    }

    @Override
    public boolean updateToken(TokenDetails tokenDetails, JCRSessionWrapper session) throws RepositoryException {
        JCRNodeWrapper tokenNode = this.getTokenNode(tokenDetails.getKey(), session);
        TokenDetails previousDetails = this.getTokenDetails(tokenNode);
        if (previousDetails != null) {
            if (!previousDetails.getName().equals(tokenDetails.getName())) {
                tokenNode.rename(tokenDetails.getName());
            }
            if (previousDetails.isActive() != tokenDetails.isActive()) {
                tokenNode.setProperty(ACTIVE, tokenDetails.isActive());
            }
            if (this.getTimeValue(previousDetails.getExpirationDate()) != this.getTimeValue(tokenDetails.getExpirationDate())) {
                tokenNode.setProperty(EXPIRATION_DATE, tokenDetails.getExpirationDate());
            }
            if (tokenDetails.getScopes() != null) {
                tokenNode.setProperty(SCOPES, (Value[])tokenDetails.getScopes().stream().map(s -> session.getValueFactory().createValue(s)).toArray(Value[]::new));
            }
            return true;
        }
        return false;
    }

    private long getTimeValue(Calendar d) {
        return d != null ? d.getTimeInMillis() : -1L;
    }

    @Override
    public boolean deleteToken(String key, JCRSessionWrapper session) throws RepositoryException {
        JCRNodeWrapper tokenNode = this.getTokenNode(key, session);
        if (tokenNode != null) {
            tokenNode.remove();
            return true;
        }
        return false;
    }

    private JCRNodeWrapper getTokenNode(String key, JCRSessionWrapper session) throws RepositoryException {
        QueryWrapper q = session.getWorkspace().getQueryManager().createQuery("select * from [patnt:token] where key=\"" + JCRContentUtils.sqlEncode((String)key) + "\"", "JCR-SQL2");
        NodeIterator ni = q.execute().getNodes();
        if (ni.hasNext()) {
            return (JCRNodeWrapper)ni.nextNode();
        }
        return null;
    }

    private TokenDetails getTokenDetails(JCRNodeWrapper node) throws RepositoryException {
        if (node == null) {
            return null;
        }
        JCRNodeWrapper parent = node.getParent().getParent();
        if (!parent.isNodeType("jnt:user")) {
            return null;
        }
        TokenDetailsImpl tokenDetails = new TokenDetailsImpl(parent.getPath(), node.getName());
        tokenDetails.setKey(node.getProperty(KEY).getString());
        tokenDetails.setDigest(node.getProperty(DIGEST).getString());
        tokenDetails.setActive(node.getProperty(ACTIVE).getBoolean());
        if (node.hasProperty(EXPIRATION_DATE)) {
            tokenDetails.setExpirationDate(node.getProperty(EXPIRATION_DATE).getDate());
        }
        tokenDetails.setCreationDate(node.getProperty("jcr:created").getDate());
        tokenDetails.setModificationDate(node.getProperty("jcr:lastModified").getDate());
        if (node.hasProperty(SCOPES)) {
            tokenDetails.setScopes(Arrays.stream(node.getProperty(SCOPES).getValues()).map(ThrowingFunction.unchecked(Value::getString)).collect(Collectors.toList()));
        } else {
            tokenDetails.setScopes(Collections.emptyList());
        }
        return tokenDetails;
    }

    private JCRNodeWrapper getTokensNode(JCRUserNode userNode) throws RepositoryException {
        if (userNode.hasNode(TOKENS)) {
            return userNode.getNode(TOKENS);
        }
        JCRNodeWrapper tokens = userNode.addNode(TOKENS, PATNT_TOKENS);
        tokens.setAclInheritanceBreak(true);
        tokens.grantRoles("u:" + userNode.getName(), Collections.singleton("owner"));
        return tokens;
    }
}

